/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.popupswitcher;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.openide.util.Utilities;

class SwitcherTableModel
extends AbstractTableModel {
    private TableModelEvent event;
    private int rows;
    private int cols;
    private SwitcherTableItem[] items;

    SwitcherTableModel(SwitcherTableItem[] switcherTableItemArray, int n) {
        this(switcherTableItemArray, n, Utilities.getUsableScreenBounds().height);
    }

    SwitcherTableModel(SwitcherTableItem[] switcherTableItemArray, int n, int n2) {
        this.items = switcherTableItemArray;
        this.computeRowsAndCols(n, n2);
    }

    private void computeRowsAndCols(int n, int n2) {
        int n3 = this.items.length;
        if (n3 > 0) {
            int n4 = n2 / n;
            int n5 = n3 / n4;
            if (n3 % n4 > 0) {
                ++n5;
            }
            int n6 = n3 / n5;
            if (n3 % n5 > 0) {
                ++n6;
            }
            this.setRowsAndColumns(n6, n5);
        } else {
            this.setRowsAndColumns(0, 0);
        }
    }

    private void setRowsAndColumns(int n, int n2) {
        if (this.rows != n || this.cols != n2) {
            this.rows = n;
            this.cols = n2;
            if (this.event == null) {
                this.event = new TableModelEvent(this);
            }
            this.fireTableChanged(this.event);
        }
    }

    public Class getColumnClass(int n) {
        return SwitcherTableItem.class;
    }

    public String getColumnName(int n) {
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return null;
        }
        int n3 = n2 * this.getRowCount() + n;
        return n3 < this.items.length ? this.items[n3] : null;
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.cols;
    }
}

