/*
 * Decompiled with CFR 0.152.
 */
package tr.background.activation;

import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import tr.background.activation.ActivatorTaskThread;

public class ActivatorTaskScheduler {
    private static ActivatorTaskScheduler instance;
    private static final long MILLISECOND = 1L;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private Timer timerSingle;
    private TimerTask taskSingle;
    private Timer timerDaily;
    private TimerTask taskDaily;

    public static ActivatorTaskScheduler instance() {
        if (instance == null) {
            instance = new ActivatorTaskScheduler();
        }
        return instance;
    }

    private ActivatorTaskScheduler() {
    }

    public void startScheduler() {
        this.stopScheduler();
        this.taskDaily = new ActivatorTimerTask();
        this.timerDaily = new Timer();
        this.timerDaily.scheduleAtFixedRate(this.taskDaily, this.getDailyTime(), 86400000L);
    }

    private Date getDailyTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 1);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public void stopScheduler() {
        if (this.timerDaily != null) {
            this.timerDaily.cancel();
            this.timerDaily = null;
        }
    }

    public void runTask(int hours, int minutes, int seconds) {
        if (this.timerSingle != null) {
            this.timerSingle.cancel();
            this.timerSingle = null;
        }
        long delay = (long)hours * 3600000L + (long)minutes * 60000L + (long)seconds * 1000L;
        this.taskSingle = new ActivatorTimerTask();
        this.timerSingle = new Timer();
        this.timerSingle.schedule(this.taskSingle, delay);
    }

    private static class ActivatorTimerTask
    extends TimerTask {
        private ActivatorTimerTask() {
        }

        public void run() {
            new ActivatorTaskThread().start();
        }
    }
}

