/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import au.com.trgtd.tr.appl.Constants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.logging.Logger;
import tr.extract.Extract;
import tr.model.Data;
import tr.model.thought.Thought;

public class ExtractThoughts {
    private static final Logger LOG = Logger.getLogger("tr.extract");
    private static final DateFormat df = Constants.DATE_FORMAT_FIXED;

    public static void process(Data data, File xmlfile) {
        try {
            Writer out = ExtractThoughts.initialise(xmlfile);
            ExtractThoughts.process(data, out);
            ExtractThoughts.finalise(out);
        }
        catch (Exception ex) {
            LOG.severe("Extracting data failed: " + ex.getMessage());
        }
    }

    private static Writer initialise(File xmlfile) throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        out.write("<data>");
        return out;
    }

    private static void finalise(Writer out) throws Exception {
        out.write("</data>");
        out.flush();
        out.close();
    }

    public static void process(Data data, Writer out) {
        try {
            LOG.info("Extracting thoughts ... ");
            ExtractThoughts.writeThoughts(data, out);
            LOG.info("Extracting thoughts ... done");
        }
        catch (Exception ex) {
            LOG.severe("Extracting thoughts failed: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static void writeThoughts(Data data, Writer out) throws Exception {
        out.write("<thoughts>\r\n");
        for (Thought thought : data.getThoughtManager().list()) {
            if (thought.isProcessed()) continue;
            out.write("<thought>\r\n");
            out.write("<created>" + df.format(thought.getCreated()) + "</created>\r\n");
            out.write("<descr>" + ExtractThoughts.escape(thought.getDescription()) + "</descr>\r\n");
            out.write("<topic>" + ExtractThoughts.escape(thought.getTopic().getName()) + "</topic>\r\n");
            out.write("<notes>" + ExtractThoughts.escape(thought.getNotes().trim()) + "</notes>\r\n");
            out.write("</thought>\r\n");
        }
        out.write("</thoughts>\r\n");
    }

    private static String escape(String string) {
        return Extract.FormatType.XML.escape(string);
    }
}

