/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.Color;

public class ColorUtilities {
    private ColorUtilities() {
    }

    public static float[] RGBtoHSL(Color color) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    public static float[] RGBtoHSL(Color color, float[] hsl) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), hsl);
    }

    public static float[] RGBtoHSL(int r, int g, int b) {
        return ColorUtilities.RGBtoHSL(r, g, b, null);
    }

    public static float[] RGBtoHSL(int r, int g, int b, float[] hsl) {
        float S;
        float H;
        float var_Max;
        float var_Min;
        if (hsl == null) {
            hsl = new float[3];
        } else if (hsl.length < 3) {
            throw new IllegalArgumentException("hsl array must have a length of at least 3");
        }
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        float var_R = (float)r / 255.0f;
        float var_G = (float)g / 255.0f;
        float var_B = (float)b / 255.0f;
        if (var_R > var_G) {
            var_Min = var_G;
            var_Max = var_R;
        } else {
            var_Min = var_R;
            var_Max = var_G;
        }
        if (var_B > var_Max) {
            var_Max = var_B;
        }
        if (var_B < var_Min) {
            var_Min = var_B;
        }
        float del_Max = var_Max - var_Min;
        float L = (var_Max + var_Min) / 2.0f;
        if (del_Max - 0.01f <= 0.0f) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = L < 0.5f ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
            float del_R = ((var_Max - var_R) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_G = ((var_Max - var_G) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_B = ((var_Max - var_B) / 6.0f + del_Max / 2.0f) / del_Max;
            H = var_R == var_Max ? del_B - del_G : (var_G == var_Max ? 0.33333334f + del_R - del_B : 0.6666667f + del_G - del_R);
            if (H < 0.0f) {
                H += 1.0f;
            }
            if (H > 1.0f) {
                H -= 1.0f;
            }
        }
        hsl[0] = H;
        hsl[1] = S;
        hsl[2] = L;
        return hsl;
    }

    public static Color HSLtoRGB(float h, float s, float l) {
        int[] rgb = ColorUtilities.HSLtoRGB(h, s, l, null);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static int[] HSLtoRGB(float h, float s, float l, int[] rgb) {
        int B;
        int G;
        int R;
        if (rgb == null) {
            rgb = new int[3];
        } else if (rgb.length < 3) {
            throw new IllegalArgumentException("rgb array must have a length of at least 3");
        }
        if (h < 0.0f) {
            h = 0.0f;
        } else if (h > 1.0f) {
            h = 1.0f;
        }
        if (s < 0.0f) {
            s = 0.0f;
        } else if (s > 1.0f) {
            s = 1.0f;
        }
        if (l < 0.0f) {
            l = 0.0f;
        } else if (l > 1.0f) {
            l = 1.0f;
        }
        if (s - 0.01f <= 0.0f) {
            R = (int)(l * 255.0f);
            G = (int)(l * 255.0f);
            B = (int)(l * 255.0f);
        } else {
            float var_2 = l < 0.5f ? l * (1.0f + s) : l + s - s * l;
            float var_1 = 2.0f * l - var_2;
            R = (int)(255.0f * ColorUtilities.hue2RGB(var_1, var_2, h + 0.33333334f));
            G = (int)(255.0f * ColorUtilities.hue2RGB(var_1, var_2, h));
            B = (int)(255.0f * ColorUtilities.hue2RGB(var_1, var_2, h - 0.33333334f));
        }
        rgb[0] = R;
        rgb[1] = G;
        rgb[2] = B;
        return rgb;
    }

    private static float hue2RGB(float v1, float v2, float vH) {
        if (vH < 0.0f) {
            vH += 1.0f;
        }
        if (vH > 1.0f) {
            vH -= 1.0f;
        }
        if (6.0f * vH < 1.0f) {
            return v1 + (v2 - v1) * 6.0f * vH;
        }
        if (2.0f * vH < 1.0f) {
            return v2;
        }
        if (3.0f * vH < 2.0f) {
            return v1 + (v2 - v1) * (0.6666667f - vH) * 6.0f;
        }
        return v1;
    }
}

