/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractCellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ComboBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor,
Serializable {
    private JComboBox comboBox;

    public ComboBoxCellEditor(JComboBox comboBox) {
        this.comboBox = comboBox;
        Handler handler = new Handler();
        JComponent editorComponent = (JComponent)comboBox.getEditor().getEditorComponent();
        editorComponent.addKeyListener(handler);
        editorComponent.setBorder(null);
        comboBox.addPropertyChangeListener(handler);
    }

    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    public boolean stopCellEditing() {
        if (this.comboBox.isEditable()) {
            this.comboBox.actionPerformed(new ActionEvent(this, 0, ""));
        }
        this.fireEditingStopped();
        return true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.comboBox.setSelectedItem(value);
        return this.comboBox;
    }

    class Handler
    extends KeyAdapter
    implements PropertyChangeListener {
        Handler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int keyCode = keyEvent.getKeyCode();
            if (keyCode == 10) {
                ComboBoxCellEditor.this.stopCellEditing();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            ComboBoxEditor editor;
            if (e.getPropertyName().equals("editor") && (editor = ComboBoxCellEditor.this.comboBox.getEditor()) != null && editor.getEditorComponent() != null) {
                JComponent editorComponent = (JComponent)ComboBoxCellEditor.this.comboBox.getEditor().getEditorComponent();
                editorComponent.addKeyListener(this);
                editorComponent.setBorder(null);
            }
        }
    }
}

