/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.xmlgraphics.image.GraphicsUtil;
import org.apache.xmlgraphics.image.rendered.FormatRed;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;

public class TIFFRenderer
extends Java2DRenderer {
    public static final String MIME_TYPE = "image/tiff";
    private static final String COMPRESSION_PACKBITS = "PackBits";
    private static final String COMPRESSION_CCITT_T6 = "CCITT T.6";
    private static final String COMPRESSION_CCITT_T4 = "CCITT T.4";
    private ImageWriterParams writerParams = new ImageWriterParams();
    private int bufferedImageType = 2;
    private OutputStream outputStream;

    public String getMimeType() {
        return MIME_TYPE;
    }

    public TIFFRenderer() {
        this.writerParams.setCompressionMethod(COMPRESSION_PACKBITS);
    }

    public void setUserAgent(FOUserAgent foUserAgent) {
        super.setUserAgent(foUserAgent);
        int dpi = Math.round(this.userAgent.getTargetResolution());
        this.writerParams.setResolution(dpi);
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        super.configure(cfg);
        String name = cfg.getChild("compression").getValue(COMPRESSION_PACKBITS);
        this.bufferedImageType = name.equalsIgnoreCase(COMPRESSION_CCITT_T6) ? 12 : (name.equalsIgnoreCase(COMPRESSION_CCITT_T4) ? 12 : 2);
        if (!"NONE".equalsIgnoreCase(name)) {
            this.writerParams.setCompressionMethod(name);
        }
        log.info((Object)("TIFF compression set to " + name));
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        super.startRenderer(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRenderer() throws IOException {
        super.stopRenderer();
        log.debug((Object)"Starting TIFF encoding ...");
        LazyPageImagesIterator pageImagesItr = new LazyPageImagesIterator(this.getNumberOfPages(), log);
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor(this.getMimeType());
        if (writer == null) {
            throw new NullPointerException("No ImageWriter for " + this.getMimeType() + " available!");
        }
        if (writer.supportsMultiImageWriter()) {
            MultiImageWriter multiWriter = writer.createMultiImageWriter(this.outputStream);
            try {
                while (pageImagesItr.hasNext()) {
                    RenderedImage img = (RenderedImage)pageImagesItr.next();
                    multiWriter.writeImage(img, this.writerParams);
                }
            }
            finally {
                multiWriter.close();
            }
        } else {
            writer.writeImage((RenderedImage)pageImagesItr.next(), this.outputStream, this.writerParams);
            if (pageImagesItr.hasNext()) {
                log.error((Object)"Image encoder does not support multiple images. Only the first page has been produced.");
            }
        }
        this.outputStream.flush();
        this.clearViewportList();
        log.debug((Object)"TIFF encoding done.");
    }

    protected BufferedImage getBufferedImage(int bitmapWidth, int bitmapHeight) {
        return new BufferedImage(bitmapWidth, bitmapHeight, this.bufferedImageType);
    }

    private class LazyPageImagesIterator
    implements Iterator {
        private Log log;
        private int count;
        private int current = 0;

        public LazyPageImagesIterator(int c, Log log) {
            this.count = c;
            this.log = log;
        }

        public boolean hasNext() {
            return this.current < this.count;
        }

        public Object next() {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[" + (this.current + 1) + "]"));
            }
            BufferedImage pageImage = null;
            try {
                pageImage = TIFFRenderer.this.getPageImage(this.current++);
            }
            catch (FOPException e) {
                this.log.error((Object)e);
                return null;
            }
            if (TIFFRenderer.COMPRESSION_CCITT_T4.equalsIgnoreCase(TIFFRenderer.this.writerParams.getCompressionMethod()) || TIFFRenderer.COMPRESSION_CCITT_T6.equalsIgnoreCase(TIFFRenderer.this.writerParams.getCompressionMethod())) {
                return pageImage;
            }
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)pageImage.getSampleModel();
            int bands = sppsm.getNumBands();
            int[] off = new int[bands];
            int w = pageImage.getWidth();
            int h = pageImage.getHeight();
            for (int i = 0; i < bands; ++i) {
                off[i] = i;
            }
            PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, w, h, bands, w * bands, off);
            FormatRed rimg = new FormatRed(GraphicsUtil.wrap((RenderedImage)pageImage), (SampleModel)sm);
            return rimg;
        }

        public void remove() {
            throw new UnsupportedOperationException("Method 'remove' is not supported.");
        }
    }
}

