/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class ImageCellPosition
extends AbstractAFPObject {
    private int _XcoSet = 0;
    private int _YcoSet = 0;
    private byte[] _XcSize = new byte[]{-1, -1};
    private byte[] _YcSize = new byte[]{-1, -1};
    private byte[] _XFillSize = new byte[]{-1, -1};
    private byte[] _YFillSize = new byte[]{-1, -1};

    public ImageCellPosition(int x, int y) {
        this._XcoSet = x;
        this._YcoSet = y;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        byte[] data = new byte[21];
        data[0] = 90;
        data[1] = 0;
        data[2] = 20;
        data[3] = -45;
        data[4] = -84;
        data[5] = 123;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        byte[] x1 = BinaryUtils.convert(this._XcoSet, 2);
        data[9] = x1[0];
        data[10] = x1[1];
        byte[] x2 = BinaryUtils.convert(this._YcoSet, 2);
        data[11] = x2[0];
        data[12] = x2[1];
        data[13] = this._XcSize[0];
        data[14] = this._XcSize[1];
        data[15] = this._YcSize[0];
        data[16] = this._YcSize[1];
        data[17] = this._XFillSize[0];
        data[18] = this._XFillSize[1];
        data[19] = this._YFillSize[0];
        data[20] = this._YFillSize[1];
        os.write(data);
    }

    public void setXSize(int xcSize) {
        byte[] x = BinaryUtils.convert(xcSize, 2);
        this._XcSize[0] = x[0];
        this._XcSize[1] = x[1];
    }

    public void setXFillSize(int xFillSize) {
        byte[] x = BinaryUtils.convert(xFillSize, 2);
        this._XFillSize[0] = x[0];
        this._XFillSize[1] = x[1];
    }

    public void setYSize(int ycSize) {
        byte[] x = BinaryUtils.convert(ycSize, 2);
        this._YcSize[0] = x[0];
        this._YcSize[1] = x[1];
    }

    public void setYFillSize(int yFillSize) {
        byte[] x = BinaryUtils.convert(yFillSize, 2);
        this._YFillSize[0] = x[0];
        this._YFillSize[1] = x[1];
    }
}

