/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.traits.MinOptMax;

public class LayoutContext {
    public static final int LINEBREAK_AT_LF_ONLY = 1;
    public static final int NEW_AREA = 2;
    public static final int IPD_UNKNOWN = 4;
    public static final int CHECK_REF_AREA = 8;
    public static final int SUPPRESS_LEADING_SPACE = 16;
    public static final int FIRST_AREA = 32;
    public static final int TRY_HYPHENATE = 64;
    public static final int LAST_AREA = 128;
    public static final int RESOLVE_LEADING_SPACE = 256;
    public static final int KEEP_WITH_NEXT_PENDING = 512;
    public static final int KEEP_WITH_PREVIOUS_PENDING = 1024;
    public int flags;
    MinOptMax stackLimit;
    private int nextSpan = 0;
    int refIPD;
    private int writingMode = 79;
    SpaceSpecifier trailingSpace;
    SpaceSpecifier leadingSpace;
    private List pendingAfterMarks;
    private List pendingBeforeMarks;
    private HyphContext hyphContext = null;
    private int bpAlignment = 135;
    private double ipdAdjust = 0.0;
    private double dSpaceAdjust = 0.0;
    private AlignmentContext alignmentContext = null;
    private int spaceBefore = 0;
    private int spaceAfter = 0;
    private int lineStartBorderAndPaddingWidth = 0;
    private int lineEndBorderAndPaddingWidth = 0;

    public LayoutContext(LayoutContext parentLC) {
        this.flags = parentLC.flags;
        this.refIPD = parentLC.refIPD;
        this.writingMode = parentLC.writingMode;
        this.stackLimit = null;
        this.leadingSpace = parentLC.leadingSpace;
        this.trailingSpace = parentLC.trailingSpace;
        this.hyphContext = parentLC.hyphContext;
        this.bpAlignment = parentLC.bpAlignment;
        this.dSpaceAdjust = parentLC.dSpaceAdjust;
        this.ipdAdjust = parentLC.ipdAdjust;
        this.alignmentContext = parentLC.alignmentContext;
        this.lineStartBorderAndPaddingWidth = parentLC.lineStartBorderAndPaddingWidth;
        this.lineEndBorderAndPaddingWidth = parentLC.lineEndBorderAndPaddingWidth;
        this.copyPendingMarksFrom(parentLC);
    }

    public LayoutContext(int flags) {
        this.flags = flags;
        this.refIPD = 0;
        this.stackLimit = new MinOptMax(0);
        this.leadingSpace = null;
        this.trailingSpace = null;
    }

    public void copyPendingMarksFrom(LayoutContext source) {
        if (source.pendingAfterMarks != null) {
            this.pendingAfterMarks = new ArrayList(source.pendingAfterMarks);
        }
        if (source.pendingBeforeMarks != null) {
            this.pendingBeforeMarks = new ArrayList(source.pendingBeforeMarks);
        }
    }

    public void setFlags(int flags) {
        this.setFlags(flags, true);
    }

    public void setFlags(int flags, boolean bSet) {
        this.flags = bSet ? (this.flags |= flags) : (this.flags &= ~flags);
    }

    public void unsetFlags(int flags) {
        this.setFlags(flags, false);
    }

    public boolean isStart() {
        return (this.flags & 2) != 0;
    }

    public boolean startsNewArea() {
        return (this.flags & 2) != 0 && this.leadingSpace != null;
    }

    public boolean isFirstArea() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isLastArea() {
        return (this.flags & 0x80) != 0;
    }

    public boolean suppressLeadingSpace() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isKeepWithNextPending() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isKeepWithPreviousPending() {
        return (this.flags & 0x400) != 0;
    }

    public void setLeadingSpace(SpaceSpecifier space) {
        this.leadingSpace = space;
    }

    public SpaceSpecifier getLeadingSpace() {
        return this.leadingSpace;
    }

    public boolean resolveLeadingSpace() {
        return (this.flags & 0x100) != 0;
    }

    public void setTrailingSpace(SpaceSpecifier space) {
        this.trailingSpace = space;
    }

    public SpaceSpecifier getTrailingSpace() {
        return this.trailingSpace;
    }

    public void addPendingAfterMark(UnresolvedListElementWithLength element) {
        if (this.pendingAfterMarks == null) {
            this.pendingAfterMarks = new ArrayList();
        }
        this.pendingAfterMarks.add(element);
    }

    public List getPendingAfterMarks() {
        if (this.pendingAfterMarks != null) {
            return Collections.unmodifiableList(this.pendingAfterMarks);
        }
        return null;
    }

    public void addPendingBeforeMark(UnresolvedListElementWithLength element) {
        if (this.pendingBeforeMarks == null) {
            this.pendingBeforeMarks = new ArrayList();
        }
        this.pendingBeforeMarks.add(element);
    }

    public List getPendingBeforeMarks() {
        if (this.pendingBeforeMarks != null) {
            return Collections.unmodifiableList(this.pendingBeforeMarks);
        }
        return null;
    }

    public void setStackLimit(MinOptMax limit) {
        this.stackLimit = limit;
    }

    public MinOptMax getStackLimit() {
        return this.stackLimit;
    }

    public void setRefIPD(int ipd) {
        this.refIPD = ipd;
    }

    public int getRefIPD() {
        return this.refIPD;
    }

    public void setHyphContext(HyphContext hyph) {
        this.hyphContext = hyph;
    }

    public HyphContext getHyphContext() {
        return this.hyphContext;
    }

    public boolean tryHyphenate() {
        return (this.flags & 0x40) != 0;
    }

    public void setBPAlignment(int alignment) {
        this.bpAlignment = alignment;
    }

    public int getBPAlignment() {
        return this.bpAlignment;
    }

    public void setSpaceAdjust(double adjust) {
        this.dSpaceAdjust = adjust;
    }

    public double getSpaceAdjust() {
        return this.dSpaceAdjust;
    }

    public void setIPDAdjust(double ipdA) {
        this.ipdAdjust = ipdA;
    }

    public double getIPDAdjust() {
        return this.ipdAdjust;
    }

    public void setAlignmentContext(AlignmentContext alignmentContext) {
        this.alignmentContext = alignmentContext;
    }

    public AlignmentContext getAlignmentContext() {
        return this.alignmentContext;
    }

    public void resetAlignmentContext() {
        if (this.alignmentContext != null) {
            this.alignmentContext = this.alignmentContext.getParentAlignmentContext();
        }
    }

    public int getLineStartBorderAndPaddingWidth() {
        return this.lineStartBorderAndPaddingWidth;
    }

    public void setLineStartBorderAndPaddingWidth(int lineStartBorderAndPaddingWidth) {
        this.lineStartBorderAndPaddingWidth = lineStartBorderAndPaddingWidth;
    }

    public int getLineEndBorderAndPaddingWidth() {
        return this.lineEndBorderAndPaddingWidth;
    }

    public void setLineEndBorderAndPaddingWidth(int lineEndBorderAndPaddingWidth) {
        this.lineEndBorderAndPaddingWidth = lineEndBorderAndPaddingWidth;
    }

    public int getNextSpan() {
        return this.nextSpan;
    }

    public void signalSpanChange(int span) {
        if (span != 0 && span != 95 && span != 5) {
            throw new IllegalArgumentException("Illegal value on signalSpanChange() for span: " + span);
        }
        this.nextSpan = span;
    }

    public int getWritingMode() {
        return this.writingMode;
    }

    public void setWritingMode(int writingMode) {
        this.writingMode = writingMode;
    }

    public int getSpaceBefore() {
        return this.spaceBefore;
    }

    public void setSpaceBefore(int spaceBefore) {
        this.spaceBefore = spaceBefore;
    }

    public int getSpaceAfter() {
        return this.spaceAfter;
    }

    public void setSpaceAfter(int spaceAfter) {
        this.spaceAfter = spaceAfter;
    }

    public String toString() {
        return "Layout Context:\nStack Limit: \t" + (this.getStackLimit() == null ? "null" : this.getStackLimit().toString()) + "\nTrailing Space: \t" + (this.getTrailingSpace() == null ? "null" : this.getTrailingSpace().toString()) + "\nLeading Space: \t" + (this.getLeadingSpace() == null ? "null" : this.getLeadingSpace().toString()) + "\nReference IPD: \t" + this.getRefIPD() + "\nSpace Adjust: \t" + this.getSpaceAdjust() + "\nIPD Adjust: \t" + this.getIPDAdjust() + "\nResolve Leading Space: \t" + this.resolveLeadingSpace() + "\nSuppress Leading Space: \t" + this.suppressLeadingSpace() + "\nIs First Area: \t" + this.isFirstArea() + "\nStarts New Area: \t" + this.startsNewArea() + "\nIs Last Area: \t" + this.isLastArea() + "\nTry Hyphenate: \t" + this.tryHyphenate() + "\nKeeps: \t[" + (this.isKeepWithNextPending() ? "keep-with-next" : "") + "][" + (this.isKeepWithPreviousPending() ? "keep-with-previous" : "") + "] pending";
    }
}

