/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.persistence;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.persistence.StreamStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;

public class FileStreamStrategy
implements StreamStrategy {
    private final FilenameFilter filter;
    private final XStream xstream;
    private final File baseDirectory;

    public FileStreamStrategy(File baseDirectory) {
        this(baseDirectory, new XStream());
    }

    public FileStreamStrategy(File baseDirectory, XStream xstream) {
        this.baseDirectory = baseDirectory;
        this.xstream = xstream;
        this.filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return new File(dir, name).isFile() && FileStreamStrategy.this.isValid(dir, name);
            }
        };
    }

    protected boolean isValid(File dir, String name) {
        return name.endsWith(".xml");
    }

    protected String extractKey(String name) {
        return this.unescape(name.substring(0, name.length() - 4));
    }

    protected String unescape(String name) {
        StringBuffer buffer = new StringBuffer();
        int currentValue = -1;
        char[] array = name.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (c == '_' && currentValue != -1) {
                if (currentValue == 0) {
                    buffer.append('_');
                } else {
                    buffer.append((char)currentValue);
                }
                currentValue = -1;
                continue;
            }
            if (c == '_') {
                currentValue = 0;
                continue;
            }
            if (currentValue != -1) {
                currentValue = currentValue * 16 + Integer.parseInt(String.valueOf(c), 16);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    protected String getName(Object key) {
        return this.escape(key.toString()) + ".xml";
    }

    protected String escape(String key) {
        StringBuffer buffer = new StringBuffer();
        char[] array = key.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (Character.isDigit(c) || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                buffer.append(c);
                continue;
            }
            if (c == '_') {
                buffer.append("__");
                continue;
            }
            buffer.append("_" + Integer.toHexString(c) + "_");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, Object value) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            try {
                this.xstream.toXML(value, os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    private File getFile(String filename) {
        return new File(this.baseDirectory, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readFile(File file) {
        Object object;
        FileInputStream is = new FileInputStream(file);
        try {
            object = this.xstream.fromXML(is);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new StreamException(e);
            }
        }
        ((InputStream)is).close();
        return object;
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.get(key);
        String filename = this.getName(key);
        this.writeFile(new File(this.baseDirectory, filename), value);
        return oldValue;
    }

    public Iterator iterator() {
        return new XmlMapEntriesIterator();
    }

    public int size() {
        return this.baseDirectory.list(this.filter).length;
    }

    public boolean containsKey(Object key) {
        File file = this.getFile(this.getName(key));
        return file.exists();
    }

    public Object get(Object key) {
        return this.readFile(this.getFile(this.getName(key)));
    }

    public Object remove(Object key) {
        File file = this.getFile(this.getName(key));
        Object value = null;
        if (file.exists()) {
            value = this.readFile(file);
            file.delete();
        }
        return value;
    }

    class XmlMapEntriesIterator
    implements Iterator {
        private File[] files;
        private int position;
        private File current;

        XmlMapEntriesIterator() {
            this.files = FileStreamStrategy.this.baseDirectory.listFiles(FileStreamStrategy.this.filter);
            this.position = -1;
            this.current = null;
        }

        public boolean hasNext() {
            return this.position + 1 < this.files.length;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.delete();
        }

        public Object next() {
            return new Map.Entry(){
                private File file;
                private String key;
                {
                    this.file = XmlMapEntriesIterator.this.current = XmlMapEntriesIterator.this.files[++XmlMapEntriesIterator.this.position];
                    this.key = FileStreamStrategy.this.extractKey(this.file.getName());
                }

                public Object getKey() {
                    return this.key;
                }

                public Object getValue() {
                    return FileStreamStrategy.this.readFile(this.file);
                }

                public Object setValue(Object value) {
                    return FileStreamStrategy.this.put(this.key, value);
                }

                public boolean equals(Object obj) {
                    if (!(obj instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e2 = (Map.Entry)obj;
                    return (this.key == null ? e2.getKey() == null : this.key.equals(e2.getKey())) && (this.getValue() == null ? e2.getValue() == null : this.getValue().equals(e2.getValue()));
                }
            };
        }
    }
}

