/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects.actions;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.Action;
import org.openide.actions.PasteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.project.Project;
import tr.view.projects.AddActionAction;
import tr.view.projects.ProjectNode;
import tr.view.projects.ToggleShowDoneAction;
import tr.view.projects.TransferNode;
import tr.view.projects.actions.SingleActionsChildren;
import tr.view.projects.actions.SingleActionsLookup;

public class SingleActionsRootNode
extends ProjectNode {
    private final Project root;
    static final int MASK_ANY = 7;

    public SingleActionsRootNode(Project root, boolean showDone) {
        super(new SingleActionsChildren(root, showDone));
        this.root = root;
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(ToggleShowDoneAction.class), null, SystemAction.get(AddActionAction.class), null, SystemAction.get(PasteAction.class)};
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public PasteType getDropType(Transferable t, int actn, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        if (dropNode != null && dropNode instanceof TransferNode) {
            final TransferNode transferNode = (TransferNode)dropNode;
            tr.model.action.Action dropAction = (tr.model.action.Action)dropNode.getLookup().lookup(tr.model.action.Action.class);
            if (dropAction != null) {
                tr.model.action.Action transferAction;
                tr.model.action.Action action = transferAction = transferNode.isMoveTransfer() ? dropAction : (tr.model.action.Action)dropAction.copy((IDGenerator)this.getData());
                if (transferAction != null && this.root.canAdd((Item)transferAction)) {
                    return new PasteType(){

                        public Transferable paste() throws IOException {
                            if (transferNode.isMoveTransfer()) {
                                SingleActionsRootNode.this.move(transferAction, transferNode);
                            } else {
                                transferAction.setThought(null);
                                SingleActionsRootNode.this.root.add((Item)transferAction);
                            }
                            return null;
                        }
                    };
                }
            }
        }
        return null;
    }

    public synchronized void setShowDone(boolean showDone) {
        if (this.showDone == showDone) {
            return;
        }
        this.showDone = showDone;
        this.setChildren((Children)new SingleActionsChildren(this.root, showDone));
        this.fireCookieChange();
        TreeView treeView = this.getTreeView();
        if (!treeView.isExpanded((Node)this)) {
            this.getTreeView().expandNode((Node)this);
        }
    }

    public TreeView getTreeView() {
        return SingleActionsLookup.lookup().getTreeView();
    }

    public ExplorerManager getExplorerManager() {
        return SingleActionsLookup.lookup().getExplorerManager();
    }

    public boolean canAddAction() {
        return true;
    }

    public boolean canAddProject() {
        return false;
    }
}

