/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.PrintStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class YarnCLI
extends Configured
implements Tool {
    public static final String STATUS_CMD = "status";
    public static final String LIST_CMD = "list";
    public static final String KILL_CMD = "kill";
    public static final String FAIL_CMD = "fail";
    public static final String MOVE_TO_QUEUE_CMD = "movetoqueue";
    public static final String HELP_CMD = "help";
    public static final String SIGNAL_CMD = "signal";
    public static final String OPTION_SUBCLUSTERID = "subClusterId";
    protected PrintStream sysout;
    protected PrintStream syserr;
    protected YarnClient client;

    public YarnCLI() {
        super(new YarnConfiguration());
    }

    protected YarnClient createYarnClient() {
        return YarnClient.createYarnClient();
    }

    protected void createAndStartYarnClient() {
        this.client = this.createYarnClient();
        this.client.init(this.getConf());
        this.client.start();
    }

    public void setSysOutPrintStream(PrintStream sysout) {
        this.sysout = sysout;
    }

    public void setSysErrPrintStream(PrintStream syserr) {
        this.syserr = syserr;
    }

    public YarnClient getClient() {
        return this.client;
    }

    public void setClient(YarnClient client) {
        this.client = client;
    }

    public void stop() {
        if (this.client != null) {
            this.client.stop();
        }
    }
}

