/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.yarn.util.Records;

public abstract class EnhancedHeadroom {
    public static EnhancedHeadroom newInstance(int totalPendingCount, int totalActiveCores) {
        EnhancedHeadroom enhancedHeadroom = Records.newRecord(EnhancedHeadroom.class);
        enhancedHeadroom.setTotalPendingCount(totalPendingCount);
        enhancedHeadroom.setTotalActiveCores(totalActiveCores);
        return enhancedHeadroom;
    }

    public abstract void setTotalPendingCount(int var1);

    public abstract int getTotalPendingCount();

    public abstract void setTotalActiveCores(int var1);

    public abstract int getTotalActiveCores();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<pendingCount:").append(this.getTotalPendingCount());
        sb.append(", activeCores:").append(this.getTotalActiveCores());
        sb.append(">");
        return sb.toString();
    }

    public double getNormalizedPendingCount(long multiplier) {
        int totalPendingCount = this.getTotalPendingCount();
        return (double)totalPendingCount * (double)multiplier;
    }
}

