/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;

public class StorageReport {
    private final DatanodeStorage storage;
    private final boolean failed;
    private final long capacity;
    private final long dfsUsed;
    private final long nonDfsUsed;
    private final long remaining;
    private final long blockPoolUsed;
    private final float blockPoolUsagePercent;
    private final String mount;
    public static final StorageReport[] EMPTY_ARRAY = new StorageReport[0];

    public StorageReport(DatanodeStorage storage, boolean failed, long capacity, long dfsUsed, long remaining, long bpUsed, long nonDfsUsed) {
        this(storage, failed, capacity, dfsUsed, remaining, bpUsed, nonDfsUsed, "");
    }

    public StorageReport(DatanodeStorage storage, boolean failed, long capacity, long dfsUsed, long remaining, long bpUsed, long nonDfsUsed, String mount) {
        this.storage = storage;
        this.failed = failed;
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.nonDfsUsed = nonDfsUsed;
        this.remaining = remaining;
        this.blockPoolUsed = bpUsed;
        this.blockPoolUsagePercent = capacity <= 0L ? 0.0f : (float)bpUsed * 100.0f / (float)capacity;
        this.mount = mount;
    }

    public DatanodeStorage getStorage() {
        return this.storage;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getDfsUsed() {
        return this.dfsUsed;
    }

    public long getNonDfsUsed() {
        return this.nonDfsUsed;
    }

    public long getRemaining() {
        return Math.max(this.remaining, 0L);
    }

    public long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    public String getMount() {
        return this.mount;
    }

    public float getBlockPoolUsagePercent() {
        return this.blockPoolUsagePercent;
    }
}

