/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;

public class DeepCopyUtils {
    private static Logger logger = LoggerFactory.getLogger(DeepCopyUtils.class);

    private DeepCopyUtils() {
    }

    public static InvCatalog copyCatalog(InvCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Catalog may not be null.");
        }
        InvCatalogImpl resultCatalog = new InvCatalogImpl(catalog.getName(), "1.0", catalog.getExpires(), ((InvCatalogImpl)catalog).getBaseURI());
        List<InvService> copiedServices = DeepCopyUtils.copyServicesIntoCopiedCatalog(catalog, resultCatalog);
        for (InvDataset curDs : catalog.getDatasets()) {
            resultCatalog.addDataset((InvDatasetImpl)DeepCopyUtils.copyDataset(curDs, copiedServices, false));
        }
        resultCatalog.finish();
        return resultCatalog;
    }

    private static List<InvService> copyServicesIntoCopiedCatalog(InvCatalog catalog, InvCatalogImpl resultCatalog) {
        List<InvService> services = catalog.getServices();
        for (InvService service : services) {
            resultCatalog.addService(DeepCopyUtils.copyService(service));
        }
        return resultCatalog.getServices();
    }

    public static InvCatalog subsetCatalogOnDataset(InvCatalog catalog, String datasetId) {
        if (catalog == null) {
            throw new IllegalArgumentException("Catalog may not be null.");
        }
        if (datasetId == null) {
            throw new IllegalArgumentException("Dataset ID may not be null.");
        }
        InvDataset ds = catalog.findDatasetByID(datasetId);
        if (ds == null) {
            throw new IllegalArgumentException("The dataset ID [" + datasetId + "] does not match the ID of a dataset in the catalog.");
        }
        return DeepCopyUtils.subsetCatalogOnDataset(catalog, ds);
    }

    public static InvCatalog subsetCatalogOnDataset(InvCatalog catalog, InvDataset dataset) {
        if (catalog == null) {
            throw new IllegalArgumentException("Catalog may not be null.");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset may not be null.");
        }
        if (dataset.getParentCatalog() != catalog) {
            throw new IllegalArgumentException("Catalog must contain the dataset.");
        }
        URI docBaseUri = DeepCopyUtils.formDocBaseUriForSubsetCatalog(catalog, dataset);
        InvCatalogImpl resultCatalog = new InvCatalogImpl(dataset.getName(), "1.0", docBaseUri);
        List<InvService> copiedServices = DeepCopyUtils.copyServicesIntoCopiedCatalog(catalog, resultCatalog);
        InvDataset topDs = DeepCopyUtils.copyDataset(dataset, copiedServices, true);
        resultCatalog.addDataset((InvDatasetImpl)topDs);
        resultCatalog.finish();
        return resultCatalog;
    }

    private static URI formDocBaseUriForSubsetCatalog(InvCatalog catalog, InvDataset dataset) {
        String catDocBaseUri = catalog.getUriString();
        String subsetDocBaseUriString = catDocBaseUri + "/" + (dataset.getID() != null ? dataset.getID() : dataset.getName());
        try {
            return new URI(subsetDocBaseUriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Bad document Base URI for new catalog [" + catalog.getUriString() + "/" + (dataset.getID() != null ? dataset.getID() : dataset.getName()) + "].", e);
        }
    }

    public static InvDataset copyDataset(InvDataset dataset, List<InvService> availableServices, boolean copyInheritedMetadataFromParents) {
        InvDatasetImpl resultDs;
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset may not be null.");
        }
        if (availableServices == null) {
            throw new IllegalArgumentException("List of available services may not be null.");
        }
        if (dataset instanceof InvCatalogRef) {
            InvCatalogRef catRef = (InvCatalogRef)dataset;
            resultDs = new InvCatalogRef(null, catRef.getName(), catRef.getXlinkHref());
        } else {
            resultDs = new InvDatasetImpl(null, dataset.getName());
        }
        resultDs.setID(dataset.getID());
        resultDs.transferMetadata((InvDatasetImpl)dataset, copyInheritedMetadataFromParents);
        if (!(dataset instanceof InvCatalogRef)) {
            String urlPath = ((InvDatasetImpl)dataset).getUrlPath();
            if (urlPath != null) {
                resultDs.setUrlPath(urlPath);
            } else {
                for (InvAccess curAccess : dataset.getAccess()) {
                    InvAccess access = DeepCopyUtils.copyAccess(curAccess, resultDs, availableServices);
                    if (access == null) continue;
                    resultDs.addAccess(access);
                }
            }
        }
        if (!(dataset instanceof InvCatalogRef)) {
            for (InvDataset curDs : dataset.getDatasets()) {
                InvDatasetImpl curDsCopy = (InvDatasetImpl)DeepCopyUtils.copyDataset(curDs, availableServices, false);
                curDsCopy.setParent(resultDs);
                resultDs.addDataset(curDsCopy);
            }
        }
        return resultDs;
    }

    public static InvAccess copyAccess(InvAccess access, InvDataset parentDataset, List<InvService> availableServices) {
        InvAccessImpl resultAccess;
        if (parentDataset == null) {
            throw new IllegalArgumentException("Parent dataset may not be null.");
        }
        String serviceName = access.getService().getName();
        InvService service = DeepCopyUtils.findServiceByName(serviceName, availableServices);
        if (service == null) {
            logger.warn("Access service [" + serviceName + "] not in available service list.");
            return null;
        }
        DataFormatType dataFormatType = access.getDataFormatType();
        if (dataFormatType == null) {
            resultAccess = new InvAccessImpl(parentDataset, access.getUrlPath(), service);
            resultAccess.setSize(access.getDataSize());
        } else {
            resultAccess = new InvAccessImpl(parentDataset, access.getUrlPath(), service.getName(), null, dataFormatType.toString(), access.getDataSize());
        }
        return resultAccess;
    }

    public static InvService findServiceByName(String name, List<InvService> servicePool) {
        if (servicePool == null) {
            return null;
        }
        for (InvService curService : servicePool) {
            if (curService.getName().equals(name)) {
                return curService;
            }
            List<InvService> nestedServices = curService.getServices();
            InvService target = nestedServices != null ? DeepCopyUtils.findServiceByName(name, nestedServices) : null;
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public static InvService copyService(InvService service) {
        if (service == null) {
            throw new IllegalArgumentException("Service may not be null.");
        }
        InvService resultService = new InvService(service.getName(), service.getServiceType().toString(), service.getBase(), service.getSuffix(), service.getDescription());
        for (InvService curService : service.getServices()) {
            resultService.addService(DeepCopyUtils.copyService(curService));
        }
        for (InvProperty curProperty : service.getProperties()) {
            resultService.addProperty(DeepCopyUtils.copyProperty(curProperty));
        }
        for (InvProperty curDatasetRoot : service.getDatasetRoots()) {
            resultService.addDatasetRoot(DeepCopyUtils.copyProperty(curDatasetRoot));
        }
        return resultService;
    }

    public static InvProperty copyProperty(InvProperty property) {
        return new InvProperty(property.getName(), property.getValue());
    }
}

