/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.KeyValueIteratorFacade;

public class ReadOnlyWindowStoreFacade<K, V>
implements ReadOnlyWindowStore<K, V> {
    protected final TimestampedWindowStore<K, V> inner;

    protected ReadOnlyWindowStoreFacade(TimestampedWindowStore<K, V> store) {
        this.inner = store;
    }

    @Override
    public V fetch(K key, long time) {
        return ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)this.inner.fetch(key, time));
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new WindowStoreIteratorFacade(this.inner.fetch(key, timeFrom, timeTo));
    }

    @Override
    public WindowStoreIterator<V> backwardFetch(K key, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new WindowStoreIteratorFacade(this.inner.backwardFetch(key, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new KeyValueIteratorFacade(this.inner.fetch(keyFrom, keyTo, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new KeyValueIteratorFacade(this.inner.backwardFetch(keyFrom, keyTo, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new KeyValueIteratorFacade(this.inner.fetchAll(timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetchAll(Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new KeyValueIteratorFacade(this.inner.backwardFetchAll(timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        return new KeyValueIteratorFacade(this.inner.all());
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardAll() {
        return new KeyValueIteratorFacade(this.inner.backwardAll());
    }

    private static class WindowStoreIteratorFacade<V>
    implements WindowStoreIterator<V> {
        final KeyValueIterator<Long, ValueAndTimestamp<V>> innerIterator;

        WindowStoreIteratorFacade(KeyValueIterator<Long, ValueAndTimestamp<V>> iterator) {
            this.innerIterator = iterator;
        }

        @Override
        public void close() {
            this.innerIterator.close();
        }

        @Override
        public Long peekNextKey() {
            return this.innerIterator.peekNextKey();
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public KeyValue<Long, V> next() {
            KeyValue innerKeyValue = (KeyValue)this.innerIterator.next();
            return KeyValue.pair(innerKeyValue.key, ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)innerKeyValue.value));
        }
    }
}

