/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Set;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.StoreBuilder;

public class KStreamTransformValues<KIn, VIn, VOut>
implements ProcessorSupplier<KIn, VIn, KIn, VOut> {
    private final ValueTransformerWithKeySupplier<KIn, VIn, VOut> valueTransformerSupplier;

    KStreamTransformValues(ValueTransformerWithKeySupplier<KIn, VIn, VOut> valueTransformerSupplier) {
        this.valueTransformerSupplier = valueTransformerSupplier;
    }

    @Override
    public Processor<KIn, VIn, KIn, VOut> get() {
        return new KStreamTransformValuesProcessor(this.valueTransformerSupplier.get());
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return this.valueTransformerSupplier.stores();
    }

    public static class KStreamTransformValuesProcessor<KIn, VIn, VOut>
    extends ContextualProcessor<KIn, VIn, KIn, VOut> {
        private final ValueTransformerWithKey<KIn, VIn, VOut> valueTransformer;

        KStreamTransformValuesProcessor(ValueTransformerWithKey<KIn, VIn, VOut> valueTransformer) {
            this.valueTransformer = valueTransformer;
        }

        @Override
        public void init(ProcessorContext<KIn, VOut> context) {
            super.init(context);
            this.valueTransformer.init(new ForwardingDisabledProcessorContext((InternalProcessorContext)context));
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            this.context().forward(record.withValue(this.valueTransformer.transform(record.key(), record.value())));
        }

        @Override
        public void close() {
            this.valueTransformer.close();
        }
    }
}

