/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.IOException;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerStream;
import opennlp.tools.tokenize.WhitespaceTokenStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;

final class CommandLineTokenizer {
    private final Tokenizer tokenizer;

    CommandLineTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    void process() {
        PerformanceMonitor perfMon = null;
        try {
            String tokenizedLine;
            PlainTextByLineStream untokenizedLineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());
            WhitespaceTokenStream tokenizedLineStream = new WhitespaceTokenStream(new TokenizerStream(this.tokenizer, untokenizedLineStream));
            perfMon = new PerformanceMonitor(System.err, "sent");
            perfMon.start();
            while ((tokenizedLine = (String)tokenizedLineStream.read()) != null) {
                System.out.println(tokenizedLine);
                perfMon.incrementCounter();
            }
        }
        catch (IOException e) {
            CmdLineUtil.handleStdinIoError(e);
        }
        perfMon.stopAndPrintFinalResult();
    }
}

