/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Angle;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.cs.AxisDirection;

public final class Longitude
extends Angle {
    private static final long serialVersionUID = -3203511772374891877L;
    public static final double MIN_VALUE = -180.0;
    public static final double MAX_VALUE = 180.0;

    public Longitude(double d) {
        super(d);
    }

    public Longitude(String string) throws NumberFormatException {
        super(string);
    }

    public Longitude(DirectPosition directPosition) throws IllegalArgumentException {
        super(Longitude.valueOf(directPosition, AxisDirection.EAST, AxisDirection.WEST));
    }

    @Override
    final char hemisphere(boolean bl) {
        return bl ? (char)'W' : 'E';
    }

    public static double normalize(double d) {
        if ((d = Math.IEEEremainder(d, 360.0)) == 180.0) {
            d = -180.0;
        }
        return d;
    }

    public static boolean isWraparound(double d, double d2) {
        return d > d2 || MathFunctions.isPositiveZero(d) && MathFunctions.isNegativeZero(d2);
    }
}

