/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;

public final class DecimalFunctions
extends Static {
    static final int EXPONENT_FOR_ZERO = -324;
    static final int EXPONENT_FOR_MAX = 308;
    private static final double[] POW10 = new double[632];

    private DecimalFunctions() {
    }

    static double pow10(int n) {
        return (n += 323) >= 0 ? (n < POW10.length ? POW10[n] : Double.POSITIVE_INFINITY) : 0.0;
    }

    public static double floatToDouble(float f) {
        int n = Math.getExponent(f) - 23;
        if (n >= 0) {
            return f;
        }
        int n2 = Numerics.getSignificand(f);
        assert (Math.scalb(n2, n) == Math.abs(f)) : f;
        int n3 = -Numerics.toExp10(n);
        double d = Math.scalb(DecimalFunctions.pow10(n3), n);
        double d2 = (double)n2 * d;
        double d3 = Math.rint(d2 / 10.0) * 10.0;
        if (Math.abs(d3 - d2) >= d / 2.0) {
            d3 = Math.rint(d2);
        }
        d3 = Math.copySign(Math.scalb(d3 / d, n), (double)f);
        assert (f == (float)d3) : f;
        return d3;
    }

    public static double deltaForDoubleToDecimal(double d) {
        int n = Math.getExponent(d) - 52;
        if (n >= 0) {
            return 0.0;
        }
        if (n < -76) {
            return n == -1075 ? 0.0 : Double.NaN;
        }
        long l = Numerics.getSignificand(d);
        assert (Math.scalb((double)l, n) == Math.abs(d)) : d;
        int n2 = -Numerics.toExp10(n);
        double d2 = Math.scalb(DecimalFunctions.pow10(n2 - 1), n + 56);
        long l2 = (long)d2;
        long l3 = l * l2 & 0xFFFFFFFFFFFFFFL;
        if (l3 >= 0x80000000000000L) {
            l3 -= 0x100000000000000L;
        }
        if (Math.abs(l3) >= l2 / 2L) {
            if ((l3 %= 0x19999999999999L) >= 0L) {
                if (l3 >= 0xCCCCCCCCCCCCCL) {
                    l3 -= 0x19999999999999L;
                }
            } else if (l3 < -3602879701896396L) {
                l3 += 0x19999999999999L;
            }
        }
        double d3 = MathFunctions.xorSign(-Math.scalb((double)l3 / d2, n), d);
        assert (Math.abs(d3) <= Math.ulp(d) / 2.0) : d;
        return d3;
    }

    public static int fractionDigitsForDelta(double d, boolean bl) {
        int n = MathFunctions.getExponent(d = Math.abs(d));
        if (n == 1024) {
            return 0;
        }
        if (d >= DecimalFunctions.pow10((n = Numerics.toExp10(n)) + 1)) {
            ++n;
        }
        n = -n;
        if (bl) {
            double d2 = DecimalFunctions.pow10(n);
            while (true) {
                double d3;
                d *= d2;
                if (!(d3 >= 9.5)) break;
                ++n;
                d -= Math.floor(d);
                d2 = 10.0;
            }
        }
        return n;
    }

    public static int fractionDigitsForValue(double d) {
        int n = Math.getExponent(d);
        if (n <= 1023) {
            return -Numerics.toExp10(n - 52);
        }
        return 0;
    }

    public static int fractionDigitsForValue(double d, int n) {
        ArgumentChecks.ensurePositive("uncertainDigits", n);
        int n2 = DecimalFunctions.fractionDigitsForValue(d);
        int n3 = n2 - n;
        if (n3 > 0 && Math.rint(d *= DecimalFunctions.pow10(n3)) % 10000.0 == 0.0) {
            return n3;
        }
        return n2;
    }

    public static int floorLog10(double d) {
        int n;
        int n2;
        if (d > 0.0 && (n2 = (n = Numerics.toExp10(MathFunctions.getExponent(d))) - -324) >= 0 && n2 < POW10.length) {
            if (POW10[n2] <= d) {
                ++n;
            }
            return n;
        }
        throw new ArithmeticException(String.valueOf(d));
    }

    public static boolean equalsIgnoreMissingFractionDigits(double d, double d2) {
        double d3 = Math.abs(d - d2);
        if (d3 < 1.0) {
            int n = Numerics.toExp10(MathFunctions.getExponent(d3));
            if ((n = Math.max(n - -323, 0)) + 1 < POW10.length && POW10[n + 1] <= d3) {
                ++n;
            }
            if ((n = 645 - n) >= 0 && n < POW10.length) {
                double d4;
                assert (d3 * d4 >= 0.1) : d3;
                double d5 = d2 * d4;
                if (Math.abs((d2 = Math.rint(d5)) - d5) <= Math.ulp(d5)) {
                    for (d4 = POW10[n]; d2 % 10.0 == 0.0 && d4 >= 10.0; d4 /= 10.0) {
                        d2 /= 10.0;
                    }
                    return Math.abs(d2 - (d *= d4)) <= 0.5;
                }
            }
        }
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    static {
        StringBuilder stringBuilder = new StringBuilder("1E");
        for (int i = 0; i < POW10.length; ++i) {
            stringBuilder.setLength(2);
            stringBuilder.append(i + -323);
            DecimalFunctions.POW10[i] = Double.parseDouble(stringBuilder.toString());
        }
    }
}

