/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;

final class ArrayConverter<S, T>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = 7108976709306360737L;
    private static final EnumSet<FunctionProperty> PROPERTIES = EnumSet.of(FunctionProperty.INVERTIBLE, FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE);
    private final ObjectConverter<?, ?> converter;

    ArrayConverter(Class<S> clazz, Class<T> clazz2, ObjectConverter<?, ?> objectConverter) {
        super(clazz, clazz2);
        assert (objectConverter.getSourceClass().isAssignableFrom(Numbers.primitiveToWrapper(clazz.getComponentType()))) : clazz;
        assert (Numbers.primitiveToWrapper(clazz2.getComponentType()).isAssignableFrom(objectConverter.getTargetClass())) : clazz2;
        this.converter = objectConverter;
    }

    @Override
    public Set<FunctionProperty> properties() {
        EnumSet<FunctionProperty> enumSet = EnumSet.copyOf(this.converter.properties());
        enumSet.retainAll(PROPERTIES);
        return enumSet;
    }

    @Override
    public T apply(S s) throws UnconvertibleObjectException {
        if (s == null) {
            return null;
        }
        int n = Array.getLength(s);
        Object object = Array.newInstance(this.targetClass.getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            Array.set(object, i, this.converter.apply(Array.get(s, i)));
        }
        return (T)object;
    }
}

