/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.UnsupportedFormatException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pkg.PackageParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RarParser
extends AbstractParser {
    private static final long serialVersionUID = 6157727985054451501L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-rar-compressed"));

    public Set<MediaType> getSupportedTypes(ParseContext arg0) {
        return SUPPORTED_TYPES;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        mediaType = metadata.get("Content-Type");
        if (mediaType != null && mediaType.contains("version=5")) {
            throw new UnsupportedFormatException("Tika does not yet support rar version 5.");
        }
        rar = null;
        try {
            tmp = new TemporaryResources();
            var10_11 = null;
            try {
                tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
                rar = new Archive(tis.getFile());
                if (rar.isEncrypted()) {
                    throw new EncryptedDocumentException();
                }
                xhtml.element("div", " ");
                header = rar.nextFileHeader();
                while (header != null && !Thread.currentThread().isInterrupted()) {
                    if (!header.isDirectory()) {
                        entrydata = PackageParser.handleEntryMetadata("".equals(header.getFileNameW()) != false ? header.getFileNameString() : header.getFileNameW(), header.getCTime(), header.getMTime(), header.getFullUnpackSize(), xhtml);
                        if (header.getFullUnpackSize() > 0L) {
                            subFile = rar.getInputStream(header);
                            var15_18 = null;
                            try {
                                if (!extractor.shouldParseEmbedded(entrydata)) ** GOTO lbl44
                                extractor.parseEmbedded(subFile, handler, entrydata, true);
                            }
                            catch (Throwable var16_20) {
                                var15_18 = var16_20;
                                throw var16_20;
                            }
                            finally {
                                if (subFile != null) {
                                    if (var15_18 != null) {
                                        try {
                                            subFile.close();
                                        }
                                        catch (Throwable var16_19) {
                                            var15_18.addSuppressed(var16_19);
                                        }
                                    } else {
                                        subFile.close();
                                    }
                                }
                            }
                        } else if (extractor.shouldParseEmbedded(entrydata)) {
                            extractor.parseEmbedded((InputStream)new ByteArrayInputStream(new byte[0]), handler, entrydata, true);
                        }
                    }
lbl44:
                    // 7 sources

                    header = rar.nextFileHeader();
                }
            }
            catch (Throwable var11_14) {
                var10_11 = var11_14;
                throw var11_14;
            }
            finally {
                if (tmp != null) {
                    if (var10_11 != null) {
                        try {
                            tmp.close();
                        }
                        catch (Throwable var11_13) {
                            var10_11.addSuppressed(var11_13);
                        }
                    } else {
                        tmp.close();
                    }
                }
            }
        }
        catch (RarException e) {
            throw new TikaException("RarParser Exception", (Throwable)e);
        }
        finally {
            if (rar != null) {
                rar.close();
            }
        }
        xhtml.endDocument();
    }
}

