/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.runtime;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.coordinator.group.runtime.CoordinatorPlayback;

public interface CoordinatorLoader<U>
extends AutoCloseable {
    public CompletableFuture<LoadSummary> load(TopicPartition var1, CoordinatorPlayback<U> var2);

    public static interface Deserializer<T> {
        public T deserialize(ByteBuffer var1, ByteBuffer var2) throws RuntimeException;
    }

    public static class LoadSummary {
        private final long startTimeMs;
        private final long endTimeMs;
        private final long numRecords;
        private final long numBytes;

        public LoadSummary(long startTimeMs, long endTimeMs, long numRecords, long numBytes) {
            this.startTimeMs = startTimeMs;
            this.endTimeMs = endTimeMs;
            this.numRecords = numRecords;
            this.numBytes = numBytes;
        }

        public long startTimeMs() {
            return this.startTimeMs;
        }

        public long endTimeMs() {
            return this.endTimeMs;
        }

        public long numRecords() {
            return this.numRecords;
        }

        public long numBytes() {
            return this.numBytes;
        }

        public String toString() {
            return "LoadSummary(startTimeMs=" + this.startTimeMs + ", endTimeMs=" + this.endTimeMs + ", numRecords=" + this.numRecords + ", numBytes=" + this.numBytes + ")";
        }
    }

    public static class UnknownRecordTypeException
    extends RuntimeException {
        private final short unknownType;

        public UnknownRecordTypeException(short unknownType) {
            super(String.format("Found an unknown record type %d", unknownType));
            this.unknownType = unknownType;
        }

        public short unknownType() {
            return this.unknownType;
        }
    }
}

