/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.consumer.VersionedMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;

public class Assignment {
    public static final Assignment EMPTY = new Assignment(0, Collections.emptyMap(), VersionedMetadata.EMPTY);
    private final byte error;
    private final Map<Uuid, Set<Integer>> partitions;
    private final VersionedMetadata metadata;

    public Assignment(Map<Uuid, Set<Integer>> partitions) {
        this(0, partitions, VersionedMetadata.EMPTY);
    }

    public Assignment(byte error, Map<Uuid, Set<Integer>> partitions, VersionedMetadata metadata) {
        this.error = error;
        this.partitions = Collections.unmodifiableMap(Objects.requireNonNull(partitions));
        this.metadata = Objects.requireNonNull(metadata);
    }

    public byte error() {
        return this.error;
    }

    public Map<Uuid, Set<Integer>> partitions() {
        return this.partitions;
    }

    public VersionedMetadata metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assignment that = (Assignment)o;
        if (this.error != that.error) {
            return false;
        }
        if (!this.partitions.equals(that.partitions)) {
            return false;
        }
        return this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        int result = this.error;
        result = 31 * result + this.partitions.hashCode();
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public String toString() {
        return "Assignment(error=" + this.error + ", partitions=" + this.partitions + ", metadata=" + this.metadata + ')';
    }

    public static Assignment fromRecord(ConsumerGroupTargetAssignmentMemberValue record) {
        return new Assignment(record.error(), record.topicPartitions().stream().collect(Collectors.toMap(ConsumerGroupTargetAssignmentMemberValue.TopicPartition::topicId, topicPartitions -> new HashSet<Integer>(topicPartitions.partitions()))), new VersionedMetadata(record.metadataVersion(), ByteBuffer.wrap(record.metadataBytes())));
    }
}

