/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.List;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.PlanetObject;
import org.apache.lucene.spatial3d.geom.StandardObjects;

public interface SerializableObject {
    public void write(OutputStream var1) throws IOException;

    public static void writePlanetObject(OutputStream outputStream, PlanetObject object) throws IOException {
        object.getPlanetModel().write(outputStream);
        SerializableObject.writeObject(outputStream, object);
    }

    public static PlanetObject readPlanetObject(InputStream inputStream) throws IOException {
        PlanetModel pm = new PlanetModel(inputStream);
        SerializableObject so = SerializableObject.readObject(pm, inputStream);
        if (!(so instanceof PlanetObject)) {
            throw new IOException("Type of object is not expected PlanetObject: " + so.getClass().getName());
        }
        return (PlanetObject)so;
    }

    public static void writeObject(OutputStream outputStream, SerializableObject object) throws IOException {
        SerializableObject.writeClass(outputStream, object.getClass());
        object.write(outputStream);
    }

    public static SerializableObject readObject(PlanetModel planetModel, InputStream inputStream) throws IOException {
        try {
            Class<?> clazz = SerializableObject.readClass(inputStream);
            return SerializableObject.readObject(planetModel, inputStream, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Can't find class for deserialization: " + e.getMessage(), e);
        }
    }

    public static SerializableObject readObject(InputStream inputStream) throws IOException {
        try {
            Class<?> clazz = SerializableObject.readClass(inputStream);
            return SerializableObject.readObject(inputStream, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Can't find class for deserialization: " + e.getMessage(), e);
        }
    }

    public static SerializableObject readObject(PlanetModel planetModel, InputStream inputStream, Class<?> clazz) throws IOException {
        try {
            Constructor<?> c = clazz.getDeclaredConstructor(PlanetModel.class, InputStream.class);
            Object object = c.newInstance(planetModel, inputStream);
            if (!(object instanceof SerializableObject)) {
                throw new IOException("Object " + clazz.getName() + " does not implement SerializableObject");
            }
            return (SerializableObject)object;
        }
        catch (InstantiationException e) {
            throw new IOException("Instantiation exception for class " + clazz.getName() + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Illegal access creating class " + clazz.getName() + ": " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("No such method exception for class " + clazz.getName() + ": " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Exception instantiating class " + clazz.getName() + ": " + e.getMessage(), e);
        }
    }

    public static SerializableObject readObject(InputStream inputStream, Class<?> clazz) throws IOException {
        try {
            Constructor<?> c = clazz.getDeclaredConstructor(InputStream.class);
            Object object = c.newInstance(inputStream);
            if (!(object instanceof SerializableObject)) {
                throw new IOException("Object " + clazz.getName() + " does not implement SerializableObject");
            }
            return (SerializableObject)object;
        }
        catch (InstantiationException e) {
            throw new IOException("Instantiation exception for class " + clazz.getName() + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Illegal access creating class " + clazz.getName() + ": " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("No such method exception for class " + clazz.getName() + ": " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Exception instantiating class " + clazz.getName() + ": " + e.getMessage(), e);
        }
    }

    public static void writeClass(OutputStream outputStream, Class<?> clazz) throws IOException {
        Integer index = StandardObjects.classRegsitry.get(clazz);
        if (index == null) {
            SerializableObject.writeBoolean(outputStream, false);
            SerializableObject.writeString(outputStream, clazz.getName());
        } else {
            SerializableObject.writeBoolean(outputStream, true);
            outputStream.write(index);
        }
    }

    public static Class<?> readClass(InputStream inputStream) throws IOException, ClassNotFoundException {
        boolean standard = SerializableObject.readBoolean(inputStream);
        if (standard) {
            int index = inputStream.read();
            return (Class)StandardObjects.codeRegsitry.get(index);
        }
        String className = SerializableObject.readString(inputStream);
        return Class.forName(className);
    }

    public static void writeString(OutputStream outputStream, String value) throws IOException {
        SerializableObject.writeByteArray(outputStream, value.getBytes(StandardCharsets.UTF_8));
    }

    public static String readString(InputStream inputStream) throws IOException {
        return new String(SerializableObject.readByteArray(inputStream), StandardCharsets.UTF_8);
    }

    public static void writePointArray(OutputStream outputStream, GeoPoint[] values) throws IOException {
        SerializableObject.writeHomogeneousArray(outputStream, values);
    }

    public static void writePointArray(OutputStream outputStream, List<GeoPoint> values) throws IOException {
        SerializableObject.writeHomogeneousArray(outputStream, values);
    }

    public static GeoPoint[] readPointArray(PlanetModel planetModel, InputStream inputStream) throws IOException {
        return (GeoPoint[])SerializableObject.readHomogeneousArray((PlanetModel)planetModel, (InputStream)inputStream, GeoPoint.class);
    }

    public static void writePolygonArray(OutputStream outputStream, GeoPolygon[] values) throws IOException {
        SerializableObject.writeHeterogeneousArray(outputStream, values);
    }

    public static void writePolygonArray(OutputStream outputStream, List<GeoPolygon> values) throws IOException {
        SerializableObject.writeHeterogeneousArray(outputStream, values);
    }

    public static GeoPolygon[] readPolygonArray(PlanetModel planetModel, InputStream inputStream) throws IOException {
        return (GeoPolygon[])SerializableObject.readHeterogeneousArray((PlanetModel)planetModel, (InputStream)inputStream, GeoPolygon.class);
    }

    public static void writeHomogeneousArray(OutputStream outputStream, SerializableObject[] values) throws IOException {
        if (values == null) {
            SerializableObject.writeInt(outputStream, 0);
        } else {
            SerializableObject.writeInt(outputStream, values.length);
            for (SerializableObject value : values) {
                value.write(outputStream);
            }
        }
    }

    public static void writeHomogeneousArray(OutputStream outputStream, List<? extends SerializableObject> values) throws IOException {
        if (values == null) {
            SerializableObject.writeInt(outputStream, 0);
        } else {
            SerializableObject.writeInt(outputStream, values.size());
            for (SerializableObject serializableObject : values) {
                serializableObject.write(outputStream);
            }
        }
    }

    public static <T extends SerializableObject> T[] readHomogeneousArray(PlanetModel planetModel, InputStream inputStream, Class<T> clazz) throws IOException {
        int count = SerializableObject.readInt(inputStream);
        SerializableObject[] rval = (SerializableObject[])Array.newInstance(clazz, count);
        for (int i = 0; i < count; ++i) {
            rval[i] = (SerializableObject)clazz.cast(SerializableObject.readObject(planetModel, inputStream, clazz));
        }
        return rval;
    }

    public static void writeHeterogeneousArray(OutputStream outputStream, SerializableObject[] values) throws IOException {
        if (values == null) {
            SerializableObject.writeInt(outputStream, 0);
        } else {
            SerializableObject.writeInt(outputStream, values.length);
            for (SerializableObject value : values) {
                SerializableObject.writeObject(outputStream, value);
            }
        }
    }

    public static void writeHeterogeneousArray(OutputStream outputStream, List<? extends SerializableObject> values) throws IOException {
        if (values == null) {
            SerializableObject.writeInt(outputStream, 0);
        } else {
            SerializableObject.writeInt(outputStream, values.size());
            for (SerializableObject serializableObject : values) {
                SerializableObject.writeObject(outputStream, serializableObject);
            }
        }
    }

    public static <T extends SerializableObject> T[] readHeterogeneousArray(PlanetModel planetModel, InputStream inputStream, Class<T> clazz) throws IOException {
        int count = SerializableObject.readInt(inputStream);
        SerializableObject[] rval = (SerializableObject[])Array.newInstance(clazz, count);
        for (int i = 0; i < count; ++i) {
            rval[i] = (SerializableObject)clazz.cast(SerializableObject.readObject(planetModel, inputStream));
        }
        return rval;
    }

    public static void writeBitSet(OutputStream outputStream, BitSet bitSet) throws IOException {
        SerializableObject.writeByteArray(outputStream, bitSet.toByteArray());
    }

    public static BitSet readBitSet(InputStream inputStream) throws IOException {
        return BitSet.valueOf(SerializableObject.readByteArray(inputStream));
    }

    public static void writeByteArray(OutputStream outputStream, byte[] bytes) throws IOException {
        SerializableObject.writeInt(outputStream, bytes.length);
        outputStream.write(bytes);
    }

    public static byte[] readByteArray(InputStream inputStream) throws IOException {
        int amt;
        int stringLength;
        int stringOffset = 0;
        byte[] bytes = new byte[stringLength];
        for (stringLength = SerializableObject.readInt(inputStream); stringLength > 0; stringLength -= amt) {
            amt = inputStream.read(bytes, stringOffset, stringLength);
            if (amt == -1) {
                throw new IOException("Unexpected end of input stream");
            }
            stringOffset += amt;
        }
        return bytes;
    }

    public static void writeDouble(OutputStream outputStream, double value) throws IOException {
        SerializableObject.writeLong(outputStream, Double.doubleToLongBits(value));
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble(SerializableObject.readLong(inputStream));
    }

    public static void writeLong(OutputStream outputStream, long value) throws IOException {
        SerializableObject.writeInt(outputStream, (int)value);
        SerializableObject.writeInt(outputStream, (int)(value >> 32));
    }

    public static long readLong(InputStream inputStream) throws IOException {
        long lower = (long)SerializableObject.readInt(inputStream) & 0xFFFFFFFFL;
        long upper = (long)SerializableObject.readInt(inputStream) << 32 & 0xFFFFFFFF00000000L;
        return lower + upper;
    }

    public static void writeInt(OutputStream outputStream, int value) throws IOException {
        outputStream.write(value);
        outputStream.write(value >> 8);
        outputStream.write(value >> 16);
        outputStream.write(value >> 24);
    }

    public static int readInt(InputStream inputStream) throws IOException {
        int l1 = inputStream.read() & 0xFF;
        int l2 = inputStream.read() << 8 & 0xFF00;
        int l3 = inputStream.read() << 16 & 0xFF0000;
        int l4 = inputStream.read() << 24 & 0xFF000000;
        return l1 + l2 + l3 + l4;
    }

    public static void writeBoolean(OutputStream outputStream, boolean value) throws IOException {
        outputStream.write(value ? 1 : 0);
    }

    public static boolean readBoolean(InputStream inputStream) throws IOException {
        int valueRead = inputStream.read();
        if (valueRead == -1) {
            throw new IOException("Unexpected end of input stream");
        }
        return valueRead != 0;
    }
}

