/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.manager.consumer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.solr.crossdc.common.MirroredSolrRequestSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void logMetrics(MetricRegistry metricRegistry) {
        log.info("Metrics Registry:");
        for (Map.Entry entry : metricRegistry.getGauges().entrySet()) {
            if (!log.isInfoEnabled()) continue;
            log.info("Gauge {}: {}", entry.getKey(), ((Gauge)entry.getValue()).getValue());
        }
        for (Map.Entry entry : metricRegistry.getCounters().entrySet()) {
            if (!log.isInfoEnabled()) continue;
            log.info("Counter {}: {}", entry.getKey(), (Object)((Counter)entry.getValue()).getCount());
        }
        for (Map.Entry entry : metricRegistry.getHistograms().entrySet()) {
            if (!log.isInfoEnabled()) continue;
            log.info("Histogram {}: {}", entry.getKey(), (Object)((Histogram)entry.getValue()).getSnapshot().toString());
        }
        for (Map.Entry entry : metricRegistry.getMeters().entrySet()) {
            if (!log.isInfoEnabled()) continue;
            log.info("Meter {}: {}", entry.getKey(), (Object)((Meter)entry.getValue()).getCount());
        }
        for (Map.Entry entry : metricRegistry.getTimers().entrySet()) {
            if (!log.isInfoEnabled()) continue;
            log.info("Timer {}: {}", entry.getKey(), (Object)((Timer)entry.getValue()).getSnapshot().toString());
        }
    }

    public static void printKafkaInfo(String host, String groupId) {
        log.info("Kafka Info: {}", (Object)host);
        Properties adminProps = new Properties();
        adminProps.put("bootstrap.servers", host);
        try (AdminClient adminClient = AdminClient.create((Properties)adminProps);){
            Set topicNames = (Set)adminClient.listTopics(new ListTopicsOptions().listInternal(false)).names().get();
            log.info("Live Topics: {}", (Object)topicNames);
            Properties consumerProps = new Properties();
            consumerProps.put("bootstrap.servers", host);
            consumerProps.put("group.id", groupId);
            consumerProps.put("key.deserializer", StringDeserializer.class.getName());
            consumerProps.put("value.deserializer", MirroredSolrRequestSerializer.class.getName());
            try (KafkaConsumer consumer = new KafkaConsumer(consumerProps);){
                for (String topic : topicNames) {
                    Set topicPartitions = consumer.assignment();
                    if (log.isInfoEnabled()) {
                        log.info("Topic Partitions: {}", (Object)topicPartitions.size());
                    }
                    for (TopicPartition topicPartition : topicPartitions) {
                        if (!topicPartition.topic().equals(topic)) continue;
                        long endOffset = consumer.position(topicPartition);
                        long committedOffset = consumer.committed(topicPartition).offset();
                        long updatesInQueue = endOffset - committedOffset;
                        log.info("Topic: {}", (Object)topic);
                        if (log.isInfoEnabled()) {
                            log.info("  Partition: {}", (Object)topicPartition.partition());
                        }
                        log.info("  End Offset: {}", (Object)endOffset);
                        log.info("  Committed Offset: {}", (Object)committedOffset);
                        log.info("  Updates in Queue: {}", (Object)updatesInQueue);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Error while fetching Kafka info", (Throwable)e);
        }
    }
}

