/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.internal.hppc.CharHashSet;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;

public class SimpleBoundaryScanner
implements BoundaryScanner {
    public static final int DEFAULT_MAX_SCAN = 20;
    public static final char[] DEFAULT_BOUNDARY_CHARS = new char[]{'.', ',', '!', '?', ' ', '\t', '\n'};
    protected int maxScan;
    protected CharHashSet boundaryChars;

    public SimpleBoundaryScanner() {
        this(20, DEFAULT_BOUNDARY_CHARS);
    }

    public SimpleBoundaryScanner(int maxScan) {
        this(maxScan, DEFAULT_BOUNDARY_CHARS);
    }

    public SimpleBoundaryScanner(Character[] boundaryChars) {
        this(20, boundaryChars);
    }

    public SimpleBoundaryScanner(int maxScan, char[] boundaryChars) {
        this.maxScan = maxScan;
        this.boundaryChars = CharHashSet.from((char[])boundaryChars);
    }

    public SimpleBoundaryScanner(int maxScan, Character[] boundaryChars) {
        this(maxScan, SimpleBoundaryScanner.toCharArray(boundaryChars));
    }

    public SimpleBoundaryScanner(int maxScan, Set<Character> boundaryChars) {
        this(maxScan, SimpleBoundaryScanner.toCharArray(boundaryChars));
    }

    private static char[] toCharArray(Character[] characters) {
        char[] chars = new char[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            chars[i] = characters[i].charValue();
        }
        return chars;
    }

    private static char[] toCharArray(Set<Character> characters) {
        Iterator<Character> iterator = characters.iterator();
        char[] chars = new char[characters.size()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = iterator.next().charValue();
        }
        return chars;
    }

    @Override
    public int findStartOffset(StringBuilder buffer, int start) {
        int offset;
        if (start > buffer.length() || start < 1) {
            return start;
        }
        int count = this.maxScan;
        for (offset = start; offset > 0 && count > 0; --offset, --count) {
            if (!this.boundaryChars.contains(buffer.charAt(offset - 1))) continue;
            return offset;
        }
        if (offset == 0) {
            return 0;
        }
        return start;
    }

    @Override
    public int findEndOffset(StringBuilder buffer, int start) {
        if (start > buffer.length() || start < 0) {
            return start;
        }
        int count = this.maxScan;
        for (int offset = start; offset < buffer.length() && count > 0; ++offset, --count) {
            if (!this.boundaryChars.contains(buffer.charAt(offset))) continue;
            return offset;
        }
        return start;
    }
}

