/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.Grib1Collection;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribCollectionBuilderFromIndex;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1GdsPredefined;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.unidata.io.RandomAccessFile;

public class Grib1CollectionBuilderFromIndex
extends GribCollectionBuilderFromIndex {
    protected FeatureCollectionConfig config;
    protected Grib1Customizer cust;

    public static GribCollection readFromIndex(String name, RandomAccessFile raf, FeatureCollectionConfig config, boolean dataOnly, Logger logger) throws IOException {
        Grib1CollectionBuilderFromIndex builder = new Grib1CollectionBuilderFromIndex(name, config, dataOnly, logger);
        if (!builder.readIndex(raf)) {
            return null;
        }
        if (builder.gc.getFiles().size() == 0) {
            logger.warn("Grib1CollectionBuilderFromIndex {}: has no files, force recreate ", (Object)builder.gc.getName());
            return null;
        }
        return builder.gc;
    }

    protected Grib1CollectionBuilderFromIndex(String name, FeatureCollectionConfig config, boolean dataOnly, Logger logger) {
        super(new Grib1Collection(name, null, config), dataOnly, logger);
        this.config = config;
    }

    @Override
    protected String getMagicStart() {
        return "Grib1Collectio2Index";
    }

    @Override
    protected GribTables makeCustomizer() throws IOException {
        Grib1ParamTables ptables = this.config.gribConfig.paramTable != null ? Grib1ParamTables.factory(this.config.gribConfig.paramTable) : Grib1ParamTables.factory(this.config.gribConfig.paramTablePath, this.config.gribConfig.lookupTablePath);
        this.cust = Grib1Customizer.factory(this.gc.center, this.gc.subcenter, this.gc.version, ptables);
        return this.cust;
    }

    @Override
    protected String getLevelNameShort(int levelCode) {
        return this.cust.getLevelNameShort(levelCode);
    }

    @Override
    protected void readGds(GribCollectionProto.Gds p) {
        Grib1Gds gds;
        byte[] rawGds = null;
        int predefined = -1;
        if (p.hasPredefinedGridDefinition()) {
            predefined = p.getPredefinedGridDefinition();
            gds = Grib1GdsPredefined.factory(this.gc.center, predefined);
        } else {
            rawGds = p.getGds().toByteArray();
            Grib1SectionGridDefinition gdss = new Grib1SectionGridDefinition(rawGds);
            gds = gdss.getGDS();
        }
        int gdsHash = p.getGdsHash() != 0 ? p.getGdsHash() : gds.hashCode();
        String nameOverride = p.hasNameOverride() ? p.getNameOverride() : null;
        this.gc.addHorizCoordSystem(gds.makeHorizCoordSys(), rawGds, gdsHash, nameOverride, predefined);
    }
}

