/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class CylindricalEqualAreaProjection
extends Projection {
    private double qp;
    private double[] apa;

    public CylindricalEqualAreaProjection() {
        this(0.0, 0.0, 0.0);
    }

    public CylindricalEqualAreaProjection(double projectionLatitude, double projectionLongitude, double trueScaleLatitude) {
        this.projectionLatitude = projectionLatitude;
        this.projectionLongitude = projectionLongitude;
        this.trueScaleLatitude = trueScaleLatitude;
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        double t = this.trueScaleLatitude;
        this.scaleFactor = Math.cos(t);
        if (this.es != 0.0) {
            t = Math.sin(t);
            this.scaleFactor /= Math.sqrt(1.0 - this.es * t * t);
            this.apa = ProjectionMath.authset(this.es);
            this.qp = ProjectionMath.qsfn(1.0, this.e, this.one_es);
        }
    }

    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        if (this.spherical) {
            xy.x = this.scaleFactor * lam;
            xy.y = Math.sin(phi) / this.scaleFactor;
        } else {
            xy.x = this.scaleFactor * lam;
            xy.y = 0.5 * ProjectionMath.qsfn(Math.sin(phi), this.e, this.one_es) / this.scaleFactor;
        }
        return xy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        if (this.spherical) {
            double d;
            double t = Math.abs(y *= this.scaleFactor);
            if (!(d - 1.0E-10 <= 1.0)) throw new ProjectionException();
            lp.y = t >= 1.0 ? (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(y);
            lp.x = x / this.scaleFactor;
            return lp;
        } else {
            lp.y = ProjectionMath.authlat(Math.asin(2.0 * y * this.scaleFactor / this.qp), this.apa);
            lp.x = x / this.scaleFactor;
        }
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isRectilinear() {
        return true;
    }
}

