/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;

public class IntBlockPool {
    public static final int INT_BLOCK_SHIFT = 13;
    public static final int INT_BLOCK_SIZE = 8192;
    public static final int INT_BLOCK_MASK = 8191;
    public int[][] buffers = new int[10][];
    private int bufferUpto = -1;
    public int intUpto = 8192;
    public int[] buffer;
    public int intOffset = -8192;
    private final Allocator allocator;

    public IntBlockPool() {
        this(new DirectAllocator());
    }

    public IntBlockPool(Allocator allocator) {
        this.allocator = allocator;
    }

    public void reset(boolean zeroFillBuffers, boolean reuseFirst) {
        if (this.bufferUpto != -1) {
            if (zeroFillBuffers) {
                for (int i = 0; i < this.bufferUpto; ++i) {
                    Arrays.fill(this.buffers[i], 0);
                }
                Arrays.fill(this.buffers[this.bufferUpto], 0, this.intUpto, 0);
            }
            if (this.bufferUpto > 0 || !reuseFirst) {
                int offset = reuseFirst ? 1 : 0;
                this.allocator.recycleIntBlocks(this.buffers, offset, 1 + this.bufferUpto);
                Arrays.fill((Object[])this.buffers, offset, this.bufferUpto + 1, null);
            }
            if (reuseFirst) {
                this.bufferUpto = 0;
                this.intUpto = 0;
                this.intOffset = 0;
                this.buffer = this.buffers[0];
            } else {
                this.bufferUpto = -1;
                this.intUpto = 8192;
                this.intOffset = -8192;
                this.buffer = null;
            }
        }
    }

    public void nextBuffer() {
        if (1 + this.bufferUpto == this.buffers.length) {
            int[][] newBuffers = new int[(int)((double)this.buffers.length * 1.5)][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
        }
        int[] nArray = this.allocator.getIntBlock();
        this.buffers[1 + this.bufferUpto] = nArray;
        this.buffer = nArray;
        ++this.bufferUpto;
        this.intUpto = 0;
        this.intOffset = Math.addExact(this.intOffset, 8192);
    }

    public static final class DirectAllocator
    extends Allocator {
        public DirectAllocator() {
            super(8192);
        }

        @Override
        public void recycleIntBlocks(int[][] blocks, int start, int end) {
        }
    }

    public static abstract class Allocator {
        protected final int blockSize;

        protected Allocator(int blockSize) {
            this.blockSize = blockSize;
        }

        public abstract void recycleIntBlocks(int[][] var1, int var2, int var3);

        public int[] getIntBlock() {
            return new int[this.blockSize];
        }
    }
}

