/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.Bits;

final class FixedBits
implements Bits {
    final long[] bits;
    final int length;

    FixedBits(long[] bits, int length) {
        this.bits = bits;
        this.length = length;
    }

    @Override
    public boolean get(int index) {
        assert (index >= 0 && index < this.length) : "index=" + index + ", numBits=" + this.length;
        int i = index >> 6;
        long bitmask = 1L << index;
        return (this.bits[i] & bitmask) != 0L;
    }

    @Override
    public int length() {
        return this.length;
    }
}

