/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty10;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ResponseMeteredLevel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;

public class InstrumentedHttpChannelListener
implements HttpChannel.Listener {
    private static final String START_ATTR = InstrumentedHttpChannelListener.class.getName() + ".start";
    private static final Set<ResponseMeteredLevel> COARSE_METER_LEVELS = EnumSet.of(ResponseMeteredLevel.COARSE, ResponseMeteredLevel.ALL);
    private static final Set<ResponseMeteredLevel> DETAILED_METER_LEVELS = EnumSet.of(ResponseMeteredLevel.DETAILED, ResponseMeteredLevel.ALL);
    private final MetricRegistry metricRegistry;
    private final Timer requests;
    private final Timer dispatches;
    private final Counter activeRequests;
    private final Counter activeDispatches;
    private final Counter activeSuspended;
    private final Meter asyncDispatches;
    private final Meter asyncTimeouts;
    private final ResponseMeteredLevel responseMeteredLevel;
    private final List<Meter> responses;
    private final Map<Integer, Meter> responseCodeMeters;
    private final String prefix;
    private final Timer getRequests;
    private final Timer postRequests;
    private final Timer headRequests;
    private final Timer putRequests;
    private final Timer deleteRequests;
    private final Timer optionsRequests;
    private final Timer traceRequests;
    private final Timer connectRequests;
    private final Timer moveRequests;
    private final Timer otherRequests;
    private final AsyncListener listener;

    public InstrumentedHttpChannelListener(MetricRegistry registry) {
        this(registry, null, ResponseMeteredLevel.COARSE);
    }

    public InstrumentedHttpChannelListener(MetricRegistry registry, String pref) {
        this(registry, pref, ResponseMeteredLevel.COARSE);
    }

    public InstrumentedHttpChannelListener(MetricRegistry registry, String pref, ResponseMeteredLevel responseMeteredLevel) {
        this.metricRegistry = registry;
        this.prefix = pref == null ? this.getClass().getName() : pref;
        this.requests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"requests"}));
        this.dispatches = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"dispatches"}));
        this.activeRequests = this.metricRegistry.counter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"active-requests"}));
        this.activeDispatches = this.metricRegistry.counter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"active-dispatches"}));
        this.activeSuspended = this.metricRegistry.counter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"active-suspended"}));
        this.asyncDispatches = this.metricRegistry.meter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"async-dispatches"}));
        this.asyncTimeouts = this.metricRegistry.meter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"async-timeouts"}));
        this.responseMeteredLevel = responseMeteredLevel;
        this.responseCodeMeters = DETAILED_METER_LEVELS.contains(responseMeteredLevel) ? new ConcurrentHashMap() : Collections.emptyMap();
        this.responses = COARSE_METER_LEVELS.contains(responseMeteredLevel) ? Collections.unmodifiableList(Arrays.asList(registry.meter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"1xx-responses"})), registry.meter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"2xx-responses"})), registry.meter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"3xx-responses"})), registry.meter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"4xx-responses"})), registry.meter(MetricRegistry.name((String)this.prefix, (String[])new String[]{"5xx-responses"})))) : Collections.emptyList();
        this.getRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"get-requests"}));
        this.postRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"post-requests"}));
        this.headRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"head-requests"}));
        this.putRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"put-requests"}));
        this.deleteRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"delete-requests"}));
        this.optionsRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"options-requests"}));
        this.traceRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"trace-requests"}));
        this.connectRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"connect-requests"}));
        this.moveRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"move-requests"}));
        this.otherRequests = this.metricRegistry.timer(MetricRegistry.name((String)this.prefix, (String[])new String[]{"other-requests"}));
        this.metricRegistry.register(MetricRegistry.name((String)this.prefix, (String[])new String[]{"percent-4xx-1m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((Meter)InstrumentedHttpChannelListener.this.responses.get(3)).getOneMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)this.prefix, (String[])new String[]{"percent-4xx-5m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((Meter)InstrumentedHttpChannelListener.this.responses.get(3)).getFiveMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)this.prefix, (String[])new String[]{"percent-4xx-15m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((Meter)InstrumentedHttpChannelListener.this.responses.get(3)).getFifteenMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getFifteenMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)this.prefix, (String[])new String[]{"percent-5xx-1m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((Meter)InstrumentedHttpChannelListener.this.responses.get(4)).getOneMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)this.prefix, (String[])new String[]{"percent-5xx-5m"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((Meter)InstrumentedHttpChannelListener.this.responses.get(4)).getFiveMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name((String)this.prefix, (String[])new String[]{"percent-5xx-15m"}), (Metric)new RatioGauge(){

            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((Meter)InstrumentedHttpChannelListener.this.responses.get(4)).getFifteenMinuteRate(), (double)InstrumentedHttpChannelListener.this.requests.getFifteenMinuteRate());
            }
        });
        this.listener = new AsyncAttachingListener();
    }

    public void onRequestBegin(Request request) {
    }

    public void onBeforeDispatch(Request request) {
        this.before(request);
    }

    public void onDispatchFailure(Request request, Throwable failure) {
    }

    public void onAfterDispatch(Request request) {
        this.after(request);
    }

    public void onRequestContent(Request request, ByteBuffer content) {
    }

    public void onRequestContentEnd(Request request) {
    }

    public void onRequestTrailers(Request request) {
    }

    public void onRequestEnd(Request request) {
    }

    public void onRequestFailure(Request request, Throwable failure) {
    }

    public void onResponseBegin(Request request) {
    }

    public void onResponseCommit(Request request) {
    }

    public void onResponseContent(Request request, ByteBuffer content) {
    }

    public void onResponseEnd(Request request) {
    }

    public void onResponseFailure(Request request, Throwable failure) {
    }

    public void onComplete(Request request) {
    }

    private void before(Request request) {
        long start;
        this.activeDispatches.inc();
        HttpChannelState state = request.getHttpChannelState();
        if (state.isInitial()) {
            this.activeRequests.inc();
            start = request.getTimeStamp();
            state.addListener(this.listener);
        } else {
            start = System.currentTimeMillis();
            this.activeSuspended.dec();
            if (state.isAsyncStarted()) {
                this.asyncDispatches.mark();
            }
        }
        request.setAttribute(START_ATTR, (Object)start);
    }

    private void after(Request request) {
        long start = (Long)request.getAttribute(START_ATTR);
        long now = System.currentTimeMillis();
        long dispatched = now - start;
        this.activeDispatches.dec();
        this.dispatches.update(dispatched, TimeUnit.MILLISECONDS);
        HttpChannelState state = request.getHttpChannelState();
        if (state.isSuspended()) {
            this.activeSuspended.inc();
        } else if (state.isInitial()) {
            this.updateResponses((HttpServletRequest)request, (HttpServletResponse)request.getResponse(), start, request.isHandled());
        }
    }

    private void updateResponses(HttpServletRequest request, HttpServletResponse response, long start, boolean isHandled) {
        if (isHandled) {
            this.mark(response.getStatus());
        } else {
            this.mark(404);
        }
        this.activeRequests.dec();
        long elapsedTime = System.currentTimeMillis() - start;
        this.requests.update(elapsedTime, TimeUnit.MILLISECONDS);
        this.requestTimer(request.getMethod()).update(elapsedTime, TimeUnit.MILLISECONDS);
    }

    private void mark(int statusCode) {
        int responseStatus;
        if (DETAILED_METER_LEVELS.contains(this.responseMeteredLevel)) {
            this.getResponseCodeMeter(statusCode).mark();
        }
        if (COARSE_METER_LEVELS.contains(this.responseMeteredLevel) && (responseStatus = statusCode / 100) >= 1 && responseStatus <= 5) {
            this.responses.get(responseStatus - 1).mark();
        }
    }

    private Meter getResponseCodeMeter(int statusCode) {
        return this.responseCodeMeters.computeIfAbsent(statusCode, sc -> this.metricRegistry.meter(MetricRegistry.name((String)this.prefix, (String[])new String[]{String.format("%d-responses", sc)})));
    }

    private Timer requestTimer(String method) {
        HttpMethod m = HttpMethod.fromString((String)method);
        if (m == null) {
            return this.otherRequests;
        }
        switch (m) {
            case GET: {
                return this.getRequests;
            }
            case POST: {
                return this.postRequests;
            }
            case PUT: {
                return this.putRequests;
            }
            case HEAD: {
                return this.headRequests;
            }
            case DELETE: {
                return this.deleteRequests;
            }
            case OPTIONS: {
                return this.optionsRequests;
            }
            case TRACE: {
                return this.traceRequests;
            }
            case CONNECT: {
                return this.connectRequests;
            }
            case MOVE: {
                return this.moveRequests;
            }
        }
        return this.otherRequests;
    }

    private class AsyncAttachingListener
    implements AsyncListener {
        private AsyncAttachingListener() {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().addListener((AsyncListener)new InstrumentedAsyncListener());
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private class InstrumentedAsyncListener
    implements AsyncListener {
        private final long startTime = System.currentTimeMillis();

        InstrumentedAsyncListener() {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            InstrumentedHttpChannelListener.this.asyncTimeouts.mark();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextState state = (AsyncContextState)event.getAsyncContext();
            HttpServletRequest request = (HttpServletRequest)state.getRequest();
            HttpServletResponse response = (HttpServletResponse)state.getResponse();
            InstrumentedHttpChannelListener.this.updateResponses(request, response, this.startTime, true);
            if (!state.getHttpChannelState().isSuspended()) {
                InstrumentedHttpChannelListener.this.activeSuspended.dec();
            }
        }
    }
}

