/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.carrot2.attrs.Attrs;
import org.carrot2.internal.nanojson.JsonParser;
import org.carrot2.language.DefaultDictionaryImpl;
import org.carrot2.language.DefaultStemmersProvider;
import org.carrot2.language.LabelFilter;
import org.carrot2.language.LabelFilterDictionary;
import org.carrot2.language.LanguageComponentsProvider;
import org.carrot2.language.StopwordFilter;
import org.carrot2.language.StopwordFilterDictionary;
import org.carrot2.util.ClassRelativeResourceLookup;
import org.carrot2.util.ResourceLookup;

public class DefaultLexicalDataProvider
implements LanguageComponentsProvider {
    @Override
    public Set<String> languages() {
        return DefaultStemmersProvider.STEMMER_SUPPLIERS.keySet();
    }

    @Override
    public ResourceLookup defaultResourceLookup() {
        return new ClassRelativeResourceLookup(this.getClass());
    }

    @Override
    public Set<Class<?>> componentTypes() {
        return Set.of(StopwordFilter.class, LabelFilter.class);
    }

    @Override
    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup, Set<Class<?>> componentTypes) throws IOException {
        if (!this.componentTypes().equals(componentTypes)) {
            throw new IllegalArgumentException();
        }
        String langPrefix = language.toLowerCase(Locale.ROOT);
        return Map.of(StopwordFilter.class, DefaultLexicalDataProvider.readDefaultWordFilters(langPrefix, resourceLookup), LabelFilter.class, DefaultLexicalDataProvider.readDefaultLabelFilters(langPrefix, resourceLookup));
    }

    @Override
    public String name() {
        return "Carrot2 Core (Lexical Data)";
    }

    /*
     * Loose catch block
     */
    public static Supplier<LabelFilter> readDefaultLabelFilters(String langPrefix, ResourceLookup resourceLookup) throws IOException {
        langPrefix = langPrefix.toLowerCase(Locale.ROOT);
        String filterDictionary = String.format(Locale.ROOT, "%s.label-filters.json", langPrefix);
        try (InputStream is = resourceLookup.open(filterDictionary);){
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                LabelFilterDictionary dictionary = Attrs.fromMap(LabelFilterDictionary.class, DefaultDictionaryImpl::new, JsonParser.object().from(reader));
                LabelFilter labelFilter = dictionary.compileLabelFilter();
                Supplier<LabelFilter> supplier = () -> labelFilter;
                return supplier;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static Supplier<StopwordFilter> readDefaultWordFilters(String langPrefix, ResourceLookup resourceLookup) throws IOException {
        langPrefix = langPrefix.toLowerCase(Locale.ROOT);
        String filterDictionary = String.format(Locale.ROOT, "%s.word-filters.json", langPrefix);
        try (InputStream is = resourceLookup.open(filterDictionary);){
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                StopwordFilterDictionary dictionary = Attrs.fromMap(StopwordFilterDictionary.class, DefaultDictionaryImpl::new, JsonParser.object().from(reader));
                StopwordFilter labelFilter = dictionary.compileStopwordFilter();
                Supplier<StopwordFilter> supplier = () -> labelFilter;
                return supplier;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }
}

