/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.immutable.pcollections;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;

public class PCollectionsImmutableMap<K, V>
implements ImmutableMap<K, V> {
    private final HashPMap<K, V> underlying;

    public static <K, V> PCollectionsImmutableMap<K, V> empty() {
        return new PCollectionsImmutableMap<K, V>(HashTreePMap.empty());
    }

    public static <K, V> PCollectionsImmutableMap<K, V> singleton(K key, V value) {
        return new PCollectionsImmutableMap<K, V>(HashTreePMap.singleton(key, value));
    }

    public PCollectionsImmutableMap(HashPMap<K, V> map) {
        this.underlying = Objects.requireNonNull(map);
    }

    @Override
    public ImmutableMap<K, V> updated(K key, V value) {
        return new PCollectionsImmutableMap<K, V>(this.underlying().plus(key, value));
    }

    @Override
    public ImmutableMap<K, V> removed(K key) {
        return new PCollectionsImmutableMap<K, V>(this.underlying().minus(key));
    }

    @Override
    public int size() {
        return this.underlying().size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.underlying().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.underlying().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)this.underlying().get(key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.underlying().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return (V)this.underlying().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.underlying().putAll(m);
    }

    @Override
    public void clear() {
        this.underlying().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.underlying().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.underlying().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.underlying().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PCollectionsImmutableMap that = (PCollectionsImmutableMap)o;
        return this.underlying().equals(that.underlying());
    }

    @Override
    public int hashCode() {
        return this.underlying().hashCode();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return (V)this.underlying().getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.underlying().forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.underlying().replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)this.underlying().putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.underlying().remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.underlying().replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return (V)this.underlying().replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)this.underlying().computeIfAbsent(key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.underlying().computeIfPresent(key, remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.underlying().compute(key, remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)this.underlying().merge(key, value, remappingFunction);
    }

    public String toString() {
        return "PCollectionsImmutableMap{underlying=" + this.underlying() + '}';
    }

    HashPMap<K, V> underlying() {
        return this.underlying;
    }
}

