/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.apache.solr.util.circuitbreaker.CircuitBreakerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static boolean reportErrorIfBreakersTripped(SolrQueryResponse rsp, List<CircuitBreaker> trippedBreakers) {
        List<CircuitBreaker> hardBreakers;
        if (CollectionUtil.isEmpty(trippedBreakers)) {
            return false;
        }
        List<CircuitBreaker> warnOnlyBreakers = trippedBreakers.stream().filter(CircuitBreaker::isWarnOnly).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(warnOnlyBreakers) && log.isWarnEnabled()) {
            log.warn("'warnOnly' circuit-breakers tripped for request: {}", (Object)CircuitBreakerRegistry.toErrorMessage(warnOnlyBreakers));
        }
        if (CollectionUtil.isEmpty(hardBreakers = trippedBreakers.stream().filter(Predicate.not(CircuitBreaker::isWarnOnly)).collect(Collectors.toList()))) {
            return false;
        }
        String errorMessage = CircuitBreakerRegistry.toErrorMessage(hardBreakers);
        rsp.add("status", "FAILURE");
        rsp.setException((Exception)((Object)new SolrException(CircuitBreaker.getErrorCode(hardBreakers), "Circuit Breakers tripped " + errorMessage)));
        return true;
    }
}

