/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.Map;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.UpdateCommand;

public class CommitUpdateCommand
extends UpdateCommand {
    public boolean optimize;
    public boolean openSearcher = true;
    public boolean waitSearcher = true;
    private boolean closeSearcher = false;
    public boolean expungeDeletes = false;
    public boolean softCommit = false;
    public boolean prepareCommit = false;
    public Map<String, String> commitData;
    public int maxOptimizeSegments = Integer.MAX_VALUE;

    public CommitUpdateCommand(SolrQueryRequest req, boolean optimize) {
        super(req);
        this.optimize = optimize;
    }

    public static CommitUpdateCommand closeOnCommit(SolrQueryRequest req, boolean optimize) {
        CommitUpdateCommand cmd = new CommitUpdateCommand(req, optimize);
        cmd.openSearcher = false;
        cmd.waitSearcher = false;
        cmd.closeSearcher = true;
        return cmd;
    }

    public boolean isClosingOnCommit() {
        return this.closeSearcher;
    }

    @Override
    public String name() {
        return "commit";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append(",optimize=").append(this.optimize).append(",openSearcher=").append(this.openSearcher).append(",expungeDeletes=").append(this.expungeDeletes).append(",softCommit=").append(this.softCommit).append(",prepareCommit=").append(this.prepareCommit);
        if (this.commitData != null) {
            sb.append(",commitData=").append(this.commitData);
        }
        sb.append('}');
        return sb.toString();
    }
}

