/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.DaciukMihovAutomatonBuilder;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;

abstract class GraphEdgeCollector
extends SimpleCollector
implements Collector {
    DocSet skipSet;
    DocSet leafNodes;
    int numHits = 0;
    BitSet bits;
    int base;
    SchemaField collectField;

    GraphEdgeCollector(SchemaField collectField, DocSet skipSet, DocSet leafNodes) {
        this.collectField = collectField;
        this.skipSet = skipSet;
        this.leafNodes = leafNodes;
    }

    public void setCollectDocs(FixedBitSet target) {
        this.bits = target;
    }

    public int getNumHits() {
        return this.numHits;
    }

    public void collect(int segDoc) throws IOException {
        int doc = segDoc + this.base;
        if (this.skipSet != null && this.skipSet.exists(doc)) {
            return;
        }
        if (this.bits != null) {
            this.bits.set(doc);
        }
        ++this.numHits;
        if (this.leafNodes == null || !this.leafNodes.exists(doc)) {
            this.addEdgeIdsToResult(segDoc);
        }
    }

    abstract void addEdgeIdsToResult(int var1) throws IOException;

    private void addDocToResult(int docWithBase) {
        this.bits.set(docWithBase);
        ++this.numHits;
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.base = context.docBase;
    }

    public abstract Query getResultQuery(SchemaField var1, boolean var2);

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    static class GraphTermsCollector
    extends GraphEdgeCollector {
        private BytesRefHash collectorTerms = new BytesRefHash();
        private SortedSetDocValues docTermOrds;

        GraphTermsCollector(SchemaField collectField, DocSet skipSet, DocSet leafNodes) {
            super(collectField, skipSet, leafNodes);
        }

        @Override
        public void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.docTermOrds = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.collectField.getName());
        }

        @Override
        void addEdgeIdsToResult(int doc) throws IOException {
            if (doc > this.docTermOrds.docID()) {
                this.docTermOrds.advance(doc);
            }
            if (doc == this.docTermOrds.docID()) {
                long ord;
                BytesRef edgeValue = new BytesRef();
                while ((ord = this.docTermOrds.nextOrd()) != -1L) {
                    edgeValue = this.docTermOrds.lookupOrd(ord);
                    this.collectorTerms.add(edgeValue);
                }
            }
        }

        @Override
        public Query getResultQuery(SchemaField matchField, boolean useAutomaton) {
            if (this.collectorTerms == null || this.collectorTerms.size() == 0) {
                return null;
            }
            AutomatonQuery q = null;
            if (useAutomaton) {
                AutomatonQuery autnQuery;
                Automaton autn = this.buildAutomaton(this.collectorTerms);
                q = autnQuery = new AutomatonQuery(new Term(matchField.getName()), autn);
            } else {
                ArrayList<BytesRef> termList = new ArrayList<BytesRef>(this.collectorTerms.size());
                for (int i = 0; i < this.collectorTerms.size(); ++i) {
                    BytesRef ref = new BytesRef();
                    this.collectorTerms.get(i, ref);
                    termList.add(ref);
                }
                q = matchField.hasDocValues() && !matchField.indexed() ? SortedDocValuesField.newSlowSetQuery((String)matchField.getName(), termList) : new TermInSetQuery(matchField.getName(), termList);
            }
            return q;
        }

        private Automaton buildAutomaton(BytesRefHash termBytesHash) {
            TreeSet<BytesRef> terms = new TreeSet<BytesRef>();
            for (int i = 0; i < termBytesHash.size(); ++i) {
                BytesRef ref = new BytesRef();
                termBytesHash.get(i, ref);
                terms.add(ref);
            }
            Automaton a = DaciukMihovAutomatonBuilder.build(terms);
            return a;
        }
    }
}

