/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.StrDocValues;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueStr;

public abstract class MultiStringFunction
extends ValueSource {
    protected final ValueSource[] sources;

    public MultiStringFunction(ValueSource[] sources) {
        this.sources = sources;
    }

    protected abstract String name();

    protected abstract CharSequence func(int var1, FunctionValues[] var2) throws IOException;

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        boolean firstTime = true;
        for (ValueSource source : this.sources) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(',');
            }
            sb.append(source);
        }
        sb.append(')');
        return sb.toString();
    }

    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues[] valsArr = new FunctionValues[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            valsArr[i] = this.sources[i].getValues(context, readerContext);
        }
        return new StrDocValues(this){

            public String strVal(int doc) throws IOException {
                CharSequence cs = MultiStringFunction.this.func(doc, valsArr);
                return cs != null ? cs.toString() : null;
            }

            public boolean exists(int doc) throws IOException {
                boolean exists = true;
                for (FunctionValues val : valsArr) {
                    exists = exists && val.exists(doc);
                }
                return exists;
            }

            public boolean bytesVal(int doc, BytesRefBuilder bytes) throws IOException {
                bytes.clear();
                CharSequence cs = MultiStringFunction.this.func(doc, valsArr);
                if (cs != null) {
                    bytes.copyChars(MultiStringFunction.this.func(doc, valsArr));
                    return true;
                }
                return false;
            }

            public String toString(int doc) throws IOException {
                StringBuilder sb = new StringBuilder();
                sb.append(MultiStringFunction.this.name()).append('(');
                boolean firstTime = true;
                for (FunctionValues vals : valsArr) {
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(vals.toString(doc));
                }
                sb.append(')');
                return sb.toString();
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueStr mval = new MutableValueStr();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) throws IOException {
                        this.mval.exists = this.bytesVal(doc, this.mval.value);
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiStringFunction)) {
            return false;
        }
        MultiStringFunction other = (MultiStringFunction)((Object)o);
        return Objects.equals(this.name(), other.name()) && Arrays.equals(this.sources, other.sources);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sources) + this.name().hashCode();
    }
}

