/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;

public class DocValuesIteratorCache {
    private static final EnumMap<DocValuesType, IOBiFunction<LeafReader, String, DocIdSetIterator>> funcMap = new EnumMap(DocValuesType.class);
    private static final FieldDocValuesSupplier NONE;
    private final SolrIndexSearcher searcher;
    private final int nLeaves;
    private final Function<String, FieldDocValuesSupplier> getSupplier;

    public DocValuesIteratorCache(SolrIndexSearcher searcher) {
        this(searcher, true);
    }

    public DocValuesIteratorCache(SolrIndexSearcher searcher, boolean cache) {
        this.searcher = searcher;
        this.nLeaves = searcher.getTopReaderContext().leaves().size();
        if (cache) {
            HashMap map = new HashMap();
            this.getSupplier = f -> map.computeIfAbsent(f, this::newEntry);
        } else {
            this.getSupplier = this::newEntry;
        }
    }

    public FieldDocValuesSupplier getSupplier(String fieldName) {
        FieldDocValuesSupplier ret = this.getSupplier.apply(fieldName);
        return ret == NONE ? null : ret;
    }

    private FieldDocValuesSupplier newEntry(String fieldName) {
        SchemaField schemaField = this.searcher.getSchema().getFieldOrNull(fieldName);
        FieldInfo fi = this.searcher.getFieldInfos().fieldInfo(fieldName);
        if (schemaField == null || !schemaField.hasDocValues() || fi == null) {
            return NONE;
        }
        DocValuesType dvType = fi.getDocValuesType();
        switch (dvType) {
            case NUMERIC: 
            case BINARY: 
            case SORTED: 
            case SORTED_NUMERIC: 
            case SORTED_SET: {
                return new FieldDocValuesSupplier(schemaField, dvType, this.nLeaves);
            }
        }
        return NONE;
    }

    static {
        funcMap.put(DocValuesType.NUMERIC, LeafReader::getNumericDocValues);
        funcMap.put(DocValuesType.BINARY, LeafReader::getBinaryDocValues);
        funcMap.put(DocValuesType.SORTED, (r, f) -> {
            SortedDocValues dvs = r.getSortedDocValues(f);
            return dvs == null || dvs.getValueCount() < 1 ? null : dvs;
        });
        funcMap.put(DocValuesType.SORTED_NUMERIC, LeafReader::getSortedNumericDocValues);
        funcMap.put(DocValuesType.SORTED_SET, (r, f) -> {
            SortedSetDocValues dvs = r.getSortedSetDocValues(f);
            return dvs == null || dvs.getValueCount() < 1L ? null : dvs;
        });
        NONE = new FieldDocValuesSupplier(null, null, 0);
    }

    public static class FieldDocValuesSupplier {
        public final SchemaField schemaField;
        public final DocValuesType type;
        private final int[] minLocalIds;
        private final int[] ceilingIds;
        private final int[] noMatchSince;
        private final DocIdSetIterator[] perLeaf;

        private FieldDocValuesSupplier(SchemaField schemaField, DocValuesType type, int nLeaves) {
            this.schemaField = schemaField;
            this.type = type;
            this.minLocalIds = new int[nLeaves];
            Arrays.fill(this.minLocalIds, -1);
            this.ceilingIds = new int[nLeaves];
            Arrays.fill(this.ceilingIds, Integer.MAX_VALUE);
            this.noMatchSince = new int[nLeaves];
            this.perLeaf = new DocIdSetIterator[nLeaves];
        }

        private DocIdSetIterator getDocValues(int localId, LeafReader leafReader, int leafOrd, boolean singleValued, IOBiFunction<LeafReader, String, DocIdSetIterator> dvFunction) throws IOException {
            int found;
            DocIdSetIterator dv;
            int min = this.minLocalIds[leafOrd];
            if (min == -1) {
                dv = dvFunction.apply(leafReader, this.schemaField.getName());
                if (dv == null) {
                    this.minLocalIds[leafOrd] = Integer.MAX_VALUE;
                    return null;
                }
                this.minLocalIds[leafOrd] = min = dv.nextDoc();
                this.perLeaf[leafOrd] = dv;
                if (localId < min) {
                    this.noMatchSince[leafOrd] = 0;
                    return null;
                }
                if (localId == min) {
                    this.noMatchSince[leafOrd] = Integer.MAX_VALUE;
                    return dv;
                }
            } else {
                if (localId < min || localId >= this.ceilingIds[leafOrd]) {
                    return null;
                }
                dv = this.perLeaf[leafOrd];
                int currentDoc = dv.docID();
                if (localId == currentDoc) {
                    if (singleValued) {
                        return dv;
                    }
                    if (this.noMatchSince[leafOrd] != Integer.MAX_VALUE) {
                        this.noMatchSince[leafOrd] = Integer.MAX_VALUE;
                        return dv;
                    }
                }
                if (localId <= currentDoc) {
                    if (localId >= this.noMatchSince[leafOrd]) {
                        return null;
                    }
                    this.perLeaf[leafOrd] = dv = dvFunction.apply(leafReader, this.schemaField.getName());
                }
            }
            if ((found = dv.advance(localId)) == localId) {
                this.noMatchSince[leafOrd] = Integer.MAX_VALUE;
                return dv;
            }
            if (found == Integer.MAX_VALUE) {
                this.ceilingIds[leafOrd] = Math.min(localId, this.ceilingIds[leafOrd]);
            }
            this.noMatchSince[leafOrd] = localId;
            return null;
        }

        public NumericDocValues getNumericDocValues(int localId, LeafReader leafReader, int leafOrd) throws IOException {
            return (NumericDocValues)this.getDocValues(localId, leafReader, leafOrd, true, funcMap.get(DocValuesType.NUMERIC));
        }

        public BinaryDocValues getBinaryDocValues(int localId, LeafReader leafReader, int leafOrd) throws IOException {
            return (BinaryDocValues)this.getDocValues(localId, leafReader, leafOrd, true, funcMap.get(DocValuesType.BINARY));
        }

        public SortedDocValues getSortedDocValues(int localId, LeafReader leafReader, int leafOrd) throws IOException {
            return (SortedDocValues)this.getDocValues(localId, leafReader, leafOrd, true, funcMap.get(DocValuesType.SORTED));
        }

        public SortedNumericDocValues getSortedNumericDocValues(int localId, LeafReader leafReader, int leafOrd) throws IOException {
            return (SortedNumericDocValues)this.getDocValues(localId, leafReader, leafOrd, false, funcMap.get(DocValuesType.SORTED_NUMERIC));
        }

        public SortedSetDocValues getSortedSetDocValues(int localId, LeafReader leafReader, int leafOrd) throws IOException {
            return (SortedSetDocValues)this.getDocValues(localId, leafReader, leafOrd, false, funcMap.get(DocValuesType.SORTED_SET));
        }
    }

    private static interface IOBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws IOException;
    }
}

