/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.apache.solr.common.util.NamedList;

@Provider
public class SolrJacksonMapper
implements ContextResolver<ObjectMapper> {
    private static final ObjectMapper objectMapper = SolrJacksonMapper.createObjectMapper();

    public ObjectMapper getContext(Class<?> type) {
        return objectMapper;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    private static ObjectMapper createObjectMapper() {
        SimpleModule customTypeModule = new SimpleModule();
        customTypeModule.addSerializer((JsonSerializer)new NamedListSerializer(NamedList.class));
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)customTypeModule);
    }

    public static class NamedListSerializer
    extends StdSerializer<NamedList> {
        public NamedListSerializer() {
            this(null);
        }

        public NamedListSerializer(Class<NamedList> nlClazz) {
            super(nlClazz);
        }

        public void serialize(NamedList value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject((Object)value.asShallowMap());
        }
    }
}

