/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.handler.export.LongComp;
import org.apache.solr.handler.export.SortValue;

public class LongValue
implements SortValue {
    protected final String field;
    protected final LongComp comp;
    protected NumericDocValues vals;
    protected long currentValue;
    private int lastDocID;
    private boolean present;

    public LongValue(String field, LongComp comp) {
        this.field = field;
        this.comp = comp;
        this.currentValue = comp.resetValue();
        this.present = false;
    }

    @Override
    public Object getCurrentValue() {
        assert (this.present);
        return this.currentValue;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public LongValue copy() {
        return new LongValue(this.field, this.comp);
    }

    @Override
    public void toGlobalValue(SortValue previousValue) {
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.vals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        this.lastDocID = 0;
    }

    @Override
    public void setCurrentValue(int docId) throws IOException {
        if (docId < this.lastDocID) {
            throw new AssertionError((Object)("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs doc=" + docId));
        }
        this.lastDocID = docId;
        int curDocID = this.vals.docID();
        if (docId > curDocID) {
            curDocID = this.vals.advance(docId);
        }
        if (docId == curDocID) {
            this.present = true;
            this.currentValue = this.vals.longValue();
        } else {
            this.present = false;
            this.currentValue = 0L;
        }
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void setCurrentValue(SortValue sv) {
        LongValue lv = (LongValue)sv;
        this.currentValue = lv.currentValue;
        this.present = lv.present;
    }

    @Override
    public int compareTo(SortValue o) {
        LongValue l = (LongValue)o;
        return this.comp.compare(this.currentValue, l.currentValue);
    }

    @Override
    public void reset() {
        this.currentValue = this.comp.resetValue();
        this.present = false;
    }
}

