/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.component.ShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteSnapshotCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public DeleteSnapshotCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        String extCollectionName = message.getStr("collection");
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? this.ccc.getZkStateReader().getAliases().resolveSimpleAlias(extCollectionName) : extCollectionName;
        String commitName = message.getStr("commitName");
        String asyncId = message.getStr("async");
        NamedList shardRequestResults = new NamedList();
        ShardHandler shardHandler = this.ccc.newShardHandler();
        SolrZkClient zkClient = this.ccc.getZkStateReader().getZkClient();
        Optional<CollectionSnapshotMetaData> meta = SolrSnapshotManager.getCollectionLevelSnapshot(zkClient, collectionName, commitName);
        if (!meta.isPresent()) {
            return;
        }
        log.info("Deleting a snapshot for collection={} with commitName={}", (Object)collectionName, (Object)commitName);
        HashSet<String> existingCores = new HashSet<String>();
        for (Object s : this.ccc.getZkStateReader().getClusterState().getCollection(collectionName).getSlices()) {
            for (Replica r : s.getReplicas()) {
                existingCores.add(r.getCoreName());
            }
        }
        HashSet<String> coresWithSnapshot = new HashSet<String>();
        for (CollectionSnapshotMetaData.CoreSnapshotMetaData coreSnapshotMetaData : meta.get().getReplicaSnapshots()) {
            if (!existingCores.contains(coreSnapshotMetaData.getCoreName())) continue;
            coresWithSnapshot.add(coreSnapshotMetaData.getCoreName());
        }
        CollectionHandlingUtils.ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
        log.info("Existing cores with snapshot for collection={} are {}", (Object)collectionName, existingCores);
        for (Slice slice : this.ccc.getZkStateReader().getClusterState().getCollection(collectionName).getSlices()) {
            for (Replica replica : slice.getReplicas()) {
                if (replica.getState() == Replica.State.DOWN || meta.get().getStatus() != CollectionSnapshotMetaData.SnapshotStatus.InProgress && !coresWithSnapshot.contains(replica.getCoreName())) continue;
                String coreName = replica.getStr("core");
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.DELETESNAPSHOT.toString()});
                params.set("name", new String[]{slice.getName()});
                params.set("core", new String[]{coreName});
                params.set("commitName", new String[]{commitName});
                log.info("Sending deletesnapshot request to core={} with commitName={}", (Object)coreName, (Object)commitName);
                shardRequestTracker.sendShardRequest(replica.getNodeName(), params, shardHandler);
            }
        }
        shardRequestTracker.processResponses((NamedList<Object>)shardRequestResults, shardHandler, false, null);
        NamedList namedList = (NamedList)shardRequestResults.get("success");
        if (namedList != null) {
            for (int i = 0; i < namedList.size(); ++i) {
                NamedList resp = (NamedList)namedList.getVal(i);
                String coreName = (String)resp.get("core");
                coresWithSnapshot.remove(coreName);
            }
        }
        if (!coresWithSnapshot.isEmpty()) {
            log.warn("Failed to delete a snapshot for collection {} with commitName = {}. Snapshot could not be deleted for following cores {}", new Object[]{collectionName, commitName, coresWithSnapshot});
            ArrayList<CollectionSnapshotMetaData.CoreSnapshotMetaData> replicasWithSnapshot = new ArrayList<CollectionSnapshotMetaData.CoreSnapshotMetaData>();
            for (CollectionSnapshotMetaData.CoreSnapshotMetaData m : meta.get().getReplicaSnapshots()) {
                if (!coresWithSnapshot.contains(m.getCoreName())) continue;
                replicasWithSnapshot.add(m);
            }
            CollectionSnapshotMetaData newResult = new CollectionSnapshotMetaData(meta.get().getName(), CollectionSnapshotMetaData.SnapshotStatus.Failed, meta.get().getCreationDate(), replicasWithSnapshot);
            SolrSnapshotManager.updateCollectionLevelSnapshot(zkClient, collectionName, newResult);
            if (log.isInfoEnabled()) {
                log.info("Saved snapshot information for collection={} with commitName={} in Zookeeper as follows: {}", new Object[]{collectionName, commitName, Utils.toJSON((Object)newResult)});
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to delete snapshot on cores " + coresWithSnapshot);
        }
        SolrSnapshotManager.deleteCollectionLevelSnapshot(zkClient, collectionName, commitName);
        log.info("Deleted Zookeeper snapshot metadata for collection={} with commitName={}", (Object)collectionName, (Object)commitName);
        log.info("Successfully deleted snapshot for collection={} with commitName={}", (Object)collectionName, (Object)commitName);
    }
}

