/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;

public final class FilterHelper {
    private static final Set<String> ALLOWED_FILTERS = new HashSet<String>();

    private FilterHelper() {
    }

    public static void isAuthorizedFilter(PreflightContext context, String filter) {
        PreflightDocument preflightDocument = context.getDocument();
        switch (preflightDocument.getSpecification()) {
            case PDF_A1A: {
                FilterHelper.isAuthorizedFilterInPDFA(context, filter);
                break;
            }
            default: {
                FilterHelper.isAuthorizedFilterInPDFA(context, filter);
            }
        }
    }

    public static void isAuthorizedFilterInPDFA(PreflightContext context, String filter) {
        if (filter != null) {
            if ("LZWDecode".equals(filter) || "LZW".equals(filter)) {
                context.addValidationError(new ValidationResult.ValidationError("1.2.7", "LZWDecode is forbidden"));
                return;
            }
            if (!ALLOWED_FILTERS.contains(filter)) {
                context.addValidationError(new ValidationResult.ValidationError("1.2.12", "This filter isn't defined in the PDF Reference Third Edition : " + filter));
            }
        }
    }

    static {
        ALLOWED_FILTERS.add("FlateDecode");
        ALLOWED_FILTERS.add("ASCIIHexDecode");
        ALLOWED_FILTERS.add("ASCII85Decode");
        ALLOWED_FILTERS.add("CCITTFaxDecode");
        ALLOWED_FILTERS.add("DCTDecode");
        ALLOWED_FILTERS.add("JBIG2Decode");
        ALLOWED_FILTERS.add("RunLengthDecode");
        ALLOWED_FILTERS.add("Fl");
        ALLOWED_FILTERS.add("AHx");
        ALLOWED_FILTERS.add("A85");
        ALLOWED_FILTERS.add("CCF");
        ALLOWED_FILTERS.add("DCT");
        ALLOWED_FILTERS.add("RL");
    }
}

