/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata.janino;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.janino.CodeGeneratorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

class DispatchGenerator {
    private final Map<MetadataHandler<?>, String> metadataHandlerToName;

    DispatchGenerator(Map<MetadataHandler<?>, String> metadataHandlerToName) {
        this.metadataHandlerToName = metadataHandlerToName;
    }

    void dispatchMethod(StringBuilder buff, Method method, Collection<? extends MetadataHandler<?>> metadataHandlers) {
        Map handlersToClasses = metadataHandlers.stream().distinct().collect(Collectors.toMap(Function.identity(), mh -> DispatchGenerator.methodAndInstanceToImplementingClass(method, mh)));
        Set<Class<? extends RelNode>> delegateClassSet = handlersToClasses.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        List<Class<? extends RelNode>> delegateClassList = DispatchGenerator.topologicalSort(delegateClassSet);
        buff.append("  private ").append(method.getReturnType().getName()).append(" ").append(method.getName()).append("_(\n").append("      ").append(RelNode.class.getName()).append(" r,\n").append("      ").append(RelMetadataQuery.class.getName()).append(" mq");
        CodeGeneratorUtil.paramList(buff, method).append(") {\n");
        if (delegateClassList.isEmpty()) {
            DispatchGenerator.throwUnknown(buff.append("    "), method).append("  }\n");
        } else {
            buff.append(delegateClassList.stream().map(clazz -> this.ifInstanceThenDispatch(method, (Collection<? extends MetadataHandler<?>>)metadataHandlers, handlersToClasses, (Class<? extends RelNode>)clazz)).collect(Collectors.joining("    } else if ", "    if ", "    } else {\n")));
            DispatchGenerator.throwUnknown(buff.append("      "), method).append("    }\n").append("  }\n");
        }
    }

    private StringBuilder ifInstanceThenDispatch(Method method, Collection<? extends MetadataHandler<?>> metadataHandlers, Map<MetadataHandler<?>, Set<Class<? extends RelNode>>> handlersToClasses, Class<? extends RelNode> clazz) {
        String handlerName = this.findProvider(metadataHandlers, handlersToClasses, clazz);
        StringBuilder buff = new StringBuilder().append("(r instanceof ").append(clazz.getName()).append(") {\n").append("      return ");
        DispatchGenerator.dispatchedCall(buff, handlerName, method, clazz);
        return buff;
    }

    private String findProvider(Collection<? extends MetadataHandler<?>> metadataHandlers, Map<MetadataHandler<?>, Set<Class<? extends RelNode>>> handlerToClasses, Class<? extends RelNode> clazz) {
        for (MetadataHandler<?> mh : metadataHandlers) {
            if (!handlerToClasses.getOrDefault(mh, (Set<Class<? extends RelNode>>)ImmutableSet.of()).contains(clazz)) continue;
            return (String)Nullness.castNonNull((Object)this.metadataHandlerToName.get(mh));
        }
        throw new RuntimeException();
    }

    private static StringBuilder throwUnknown(StringBuilder buff, Method method) {
        return buff.append("      throw new ").append(IllegalArgumentException.class.getName()).append("(\"No handler for method [").append(method).append("] applied to argument of type [\" + r.getClass() + ").append("\"]; we recommend you create a catch-all (RelNode) handler\"").append(");\n");
    }

    private static void dispatchedCall(StringBuilder buff, String handlerName, Method method, Class<? extends RelNode> clazz) {
        buff.append(handlerName).append(".").append(method.getName()).append("((").append(clazz.getName()).append(") r, mq");
        CodeGeneratorUtil.argList(buff, method);
        buff.append(");\n");
    }

    private static Set<Class<? extends RelNode>> methodAndInstanceToImplementingClass(Method method, MetadataHandler<?> handler) {
        HashSet<Class<? extends RelNode>> set = new HashSet<Class<? extends RelNode>>();
        for (Method m : handler.getClass().getMethods()) {
            Class<? extends RelNode> aClass = DispatchGenerator.toRelClass(method, m);
            if (aClass == null) continue;
            set.add(aClass);
        }
        return set;
    }

    private static @Nullable Class<? extends RelNode> toRelClass(Method superMethod, Method candidate) {
        if (!superMethod.getName().equals(candidate.getName())) {
            return null;
        }
        if (superMethod.getParameterCount() != candidate.getParameterCount()) {
            return null;
        }
        Class<?>[] cpt = candidate.getParameterTypes();
        Class<?>[] smpt = superMethod.getParameterTypes();
        if (!RelNode.class.isAssignableFrom(cpt[0])) {
            return null;
        }
        if (!RelMetadataQuery.class.equals(cpt[1])) {
            return null;
        }
        for (int i = 2; i < smpt.length; ++i) {
            if (cpt[i] == smpt[i]) continue;
            return null;
        }
        return cpt[0];
    }

    private static List<Class<? extends RelNode>> topologicalSort(Collection<Class<? extends RelNode>> list) {
        ArrayList<Class<? extends RelNode>> l = new ArrayList<Class<? extends RelNode>>();
        ArrayDeque s = list.stream().sorted(Comparator.comparing(Class::getName)).collect(Collectors.toCollection(ArrayDeque::new));
        while (!s.isEmpty()) {
            Class n = (Class)s.remove();
            boolean found = false;
            for (Class other : s) {
                if (!n.isAssignableFrom(other)) continue;
                found = true;
                break;
            }
            if (found) {
                s.add(n);
                continue;
            }
            l.add(n);
        }
        return l;
    }
}

