/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.entries.MagicMatcher;
import com.j256.simplemagic.types.StringType;

public class BigEndianString16Type
extends StringType {
    @Override
    public Object extractValueFromBytes(int offset, byte[] bytes, boolean required) {
        int len;
        for (len = offset; len < bytes.length - 1 && (bytes[len] != 0 || bytes[len + 1] != 0); len += 2) {
        }
        char[] chars = new char[len / 2];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.bytesToChar(bytes[i * 2], bytes[i * 2 + 1]);
        }
        return chars;
    }

    @Override
    public Object isMatch(Object testValue, Long andValue, boolean unsignedType, Object extractedValue, MagicMatcher.MutableOffset mutableOffset, byte[] bytes) {
        char[] chars = (char[])extractedValue;
        return super.findOffsetMatch((StringType.TestInfo)testValue, mutableOffset.offset, mutableOffset, null, chars, chars.length);
    }

    protected char bytesToChar(int firstByte, int secondByte) {
        return (char)((firstByte << 8) + secondByte);
    }
}

