/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.Inverter;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class Orthographic
extends NormalizedProjection {
    private static final long serialVersionUID = -6140156868989213344L;
    private final double sin\u03c60;
    private final double cos\u03c60;
    private final double m\u212f2_cos\u03c60;

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.Orthographic.LONGITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.Orthographic.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.Orthographic.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, null);
    }

    public Orthographic(OperationMethod operationMethod, Parameters parameters) {
        this(Orthographic.initializer(operationMethod, parameters));
    }

    private Orthographic(Initializer initializer) {
        super(initializer, null);
        double d = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.Orthographic.LATITUDE_OF_ORIGIN));
        this.sin\u03c60 = Math.sin(d);
        this.cos\u03c60 = Math.cos(d);
        this.m\u212f2_cos\u03c60 = (1.0 - this.eccentricitySquared) * this.cos\u03c60;
        if (this.eccentricity != 0.0) {
            double d2 = initializer.radiusOfCurvature(this.sin\u03c60);
            MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
            matrixSIS.convertBefore(1, null, this.eccentricitySquared * d2 * (this.sin\u03c60 * this.cos\u03c60));
        }
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"\u03c6\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.cos\u03c60 < 0.7853981633974483 ? Math.acos(this.cos\u03c60) : Math.asin(this.sin\u03c60)};
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        Matrix2 matrix2 = bl ? new Matrix2() : null;
        this.transform(dArray, n, dArray2, n2, matrix2);
        return matrix2;
    }

    final double transform(double[] dArray, int n, double[] dArray2, int n2, Matrix2 matrix2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = dArray[n];
        double d7 = dArray[n + 1];
        double d8 = Math.cos(d6);
        double d9 = Math.sin(d6);
        double d10 = Math.cos(d7);
        double d11 = Math.sin(d7);
        double d12 = this.sin\u03c60 * d11;
        double d13 = d12 + this.cos\u03c60 * (d5 = d10 * d8);
        if (d13 >= 0.0 || matrix2 instanceof Inverter) {
            d4 = d10 * d9;
            d3 = this.m\u212f2_cos\u03c60 * d11 - this.sin\u03c60 * d5;
            d2 = 1.0;
            if (this.eccentricity != 0.0) {
                d = this.eccentricity * d11;
                d2 = Math.sqrt(1.0 - d * d);
                d4 /= d2;
                d3 /= d2;
            }
        } else {
            d4 = Double.NaN;
            d3 = Double.NaN;
            d2 = Double.NaN;
        }
        if (dArray2 != null) {
            dArray2[n2] = d4;
            dArray2[n2 + 1] = d3;
        }
        if (matrix2 != null) {
            d = (1.0 - this.eccentricitySquared) / (d2 * d2 * d2);
            matrix2.m00 = d5 / d2;
            matrix2.m01 = -d11 * d9 * d;
            matrix2.m10 = this.sin\u03c60 * d4;
            matrix2.m11 = (this.cos\u03c60 * d10 + d12 * d8) * d;
        }
        return d10;
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = d * d + d2 * d2;
        double d4 = Math.sqrt(1.0 - d3);
        dArray2[n2] = Math.atan2(d, d4 * this.cos\u03c60 - d2 * this.sin\u03c60);
        dArray2[n2 + 1] = Math.asin(d4 * this.sin\u03c60 + d2 * this.cos\u03c60);
        if (this.eccentricity != 0.0) {
            Inverter inverter = new Inverter();
            inverter.inverseTransform(this, d, d2, dArray2, n2);
            dArray2[n2] = Math.IEEEremainder(dArray2[n2], Math.PI);
        }
    }
}

