/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import org.apache.sis.internal.referencing.j2d.ImmutableAffineTransform;
import org.apache.sis.internal.referencing.j2d.Tile;

final class TileTranslation {
    private final AffineTransform gridToCRS;
    private final int dx;
    private final int dy;

    TileTranslation(Dimension dimension, AffineTransform affineTransform, int n, int n2) {
        this.dx = n / dimension.width;
        this.dy = n2 / dimension.height;
        affineTransform = new AffineTransform(affineTransform);
        affineTransform.scale(dimension.width, dimension.height);
        affineTransform.translate(n %= dimension.width, n2 %= dimension.height);
        this.gridToCRS = new ImmutableAffineTransform(affineTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void applyTo(Tile tile) {
        Tile tile2 = tile;
        synchronized (tile2) {
            tile.translate(this.dx, this.dy);
            tile.setGridToCRS(this.gridToCRS);
        }
    }
}

