/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.image;

import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.internal.processing.image.IsolineTracer;
import org.apache.sis.internal.processing.image.TiledProcess;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class Isolines {
    private final IsolineTracer.Level[] levels;

    private Isolines(IsolineTracer isolineTracer, int n, double[] dArray, int n2) {
        this.levels = new IsolineTracer.Level[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            IsolineTracer isolineTracer2 = isolineTracer;
            Objects.requireNonNull(isolineTracer2);
            this.levels[i] = isolineTracer2.new IsolineTracer.Level(n, dArray[i], n2);
        }
    }

    private static double[][] cloneAndSort(double[][] dArray) {
        dArray.clone();
        for (int i = 0; i < dArray.length; ++i) {
            int n;
            double[] dArray2 = dArray[i];
            ArgumentChecks.ensureNonNullElement("levels", i, dArray2);
            dArray2 = (double[])dArray2.clone();
            Arrays.sort(dArray2);
            for (n = dArray2.length; n > 0 && Double.isNaN(dArray2[n - 1]); --n) {
            }
            int n2 = n;
            while (--n2 > 0) {
                if (dArray2[n2] != dArray2[n2 - 1]) continue;
                System.arraycopy(dArray2, n2, dArray2, n2 - 1, n-- - n2);
            }
            dArray[i] = ArraysExt.resize(dArray2, n);
        }
        return dArray;
    }

    private void setMaskBit(double d, int n) {
        for (IsolineTracer.Level level : this.levels) {
            if (level.value > d) break;
            level.isDataAbove |= n;
        }
    }

    public static Isolines[] generate(RenderedImage renderedImage, double[][] dArray, MathTransform mathTransform) throws TransformException {
        ArgumentChecks.ensureNonNull("data", renderedImage);
        ArgumentChecks.ensureNonNull("levels", dArray);
        return Isolines.flush(Isolines.generate(Isolines.iterators().create(renderedImage), Isolines.cloneAndSort(dArray), mathTransform));
    }

    public static Future<Isolines[]> parallelGenerate(RenderedImage renderedImage, double[][] dArray, MathTransform mathTransform) {
        ArgumentChecks.ensureNonNull("data", renderedImage);
        ArgumentChecks.ensureNonNull("levels", dArray);
        return new Process(renderedImage, Isolines.cloneAndSort(dArray), mathTransform).execute();
    }

    private static PixelIterator.Builder iterators() {
        return new PixelIterator.Builder().setIteratorOrder(SequenceType.LINEAR);
    }

    private static Isolines[] flush(Isolines[] isolinesArray) throws TransformException {
        for (Isolines isolines : isolinesArray) {
            for (IsolineTracer.Level level : isolines.levels) {
                level.flush();
            }
        }
        return isolinesArray;
    }

    private static Isolines[] generate(PixelIterator pixelIterator, double[][] dArray, MathTransform mathTransform) throws TransformException {
        int n;
        int n2;
        int n3 = pixelIterator.getNumBands();
        double[] dArray2 = new double[n3 * 4];
        IsolineTracer isolineTracer = new IsolineTracer(dArray2, n3, pixelIterator.getDomain(), mathTransform);
        int n4 = pixelIterator.getDomain().width - 1;
        Isolines[] isolinesArray = new Isolines[n3];
        double[] dArray3 = ArraysExt.EMPTY_DOUBLE;
        for (int i = 0; i < n3; ++i) {
            if (i < dArray.length) {
                dArray3 = dArray[i];
                ArgumentChecks.ensureNonNullElement("levels", i, dArray3);
                dArray3 = (double[])dArray3.clone();
            }
            isolinesArray[i] = new Isolines(isolineTracer, i, dArray3, n4);
        }
        dArray3 = new double[n3];
        double[] dArray4 = new double[n3 * (n4 + 1)];
        for (n2 = 0; n2 < dArray4.length; n2 += n3) {
            if (!pixelIterator.next()) {
                return isolinesArray;
            }
            System.arraycopy(pixelIterator.getPixel(dArray3), 0, dArray4, n2, n3);
        }
        n2 = n3 * 2;
        int n5 = n3 * 3;
        block2: while (pixelIterator.next()) {
            int n6;
            int n7;
            System.arraycopy(dArray4, 0, dArray2, 0, n2);
            System.arraycopy(pixelIterator.getPixel(dArray3), 0, dArray2, n2, n3);
            if (!pixelIterator.next()) break;
            System.arraycopy(pixelIterator.getPixel(dArray3), 0, dArray2, n5, n3);
            System.arraycopy(dArray2, n2, dArray4, 0, n2);
            n = 0;
            for (n7 = 1; n7 <= 8; n7 <<= 1) {
                for (n6 = 0; n6 < n3; ++n6) {
                    isolinesArray[n6].setMaskBit(dArray2[n++], n7);
                }
            }
            Isolines[] isolinesArray2 = isolinesArray;
            n7 = isolinesArray2.length;
            for (n6 = 0; n6 < n7; ++n6) {
                IsolineTracer.Level[] levelArray = isolinesArray2[n6];
                IsolineTracer.Level[] levelArray2 = levelArray.levels;
                int n8 = levelArray2.length;
                for (int i = 0; i < n8; ++i) {
                    IsolineTracer.Level level = levelArray2[i];
                    level.interpolate();
                }
            }
            isolineTracer.x = 1;
            while (isolineTracer.x < n4) {
                n = (isolineTracer.x + 1) * n3;
                if (!pixelIterator.next()) break block2;
                if (n3 == 1) {
                    dArray2[2] = dArray2[3];
                    dArray2[0] = dArray2[1];
                    dArray2[1] = dArray4[n];
                    dArray2[3] = dArray4[n] = pixelIterator.getSampleDouble(0);
                } else {
                    System.arraycopy(dArray2, n3, dArray2, 0, n3);
                    System.arraycopy(dArray2, n5, dArray2, n2, n3);
                    System.arraycopy(dArray4, n, dArray2, n3, n3);
                    System.arraycopy(pixelIterator.getPixel(dArray3), 0, dArray2, n5, n3);
                    System.arraycopy(dArray2, n5, dArray4, n, n3);
                }
                for (n7 = 0; n7 < n3; ++n7) {
                    Isolines isolines = isolinesArray[n7];
                    for (IsolineTracer.Level level : isolines.levels) {
                        level.nextColumn();
                    }
                    isolines.setMaskBit(dArray2[n3 + n7], 2);
                    isolines.setMaskBit(dArray2[n5 + n7], 8);
                    for (IsolineTracer.Level level : isolines.levels) {
                        level.interpolate();
                    }
                }
                ++isolineTracer.x;
            }
            for (n = 0; n < n3; ++n) {
                for (IsolineTracer.Level level : isolinesArray[n].levels) {
                    level.finishedRow();
                }
            }
            isolineTracer.x = 0;
            ++isolineTracer.y;
        }
        for (n = 0; n < n3; ++n) {
            for (IsolineTracer.Level level : isolinesArray[n].levels) {
                level.finish();
            }
        }
        return isolinesArray;
    }

    public final NavigableMap<Double, Shape> polylines() {
        TreeMap<Double, Shape> treeMap = new TreeMap<Double, Shape>();
        for (IsolineTracer.Level level : this.levels) {
            Shape shape = level.shape;
            if (shape == null) continue;
            treeMap.put(level.value, shape);
        }
        return treeMap;
    }

    private static NavigableMap<Double, Shape>[] toArray(Isolines[] isolinesArray) {
        NavigableMap[] navigableMapArray = new NavigableMap[isolinesArray.length];
        for (int i = 0; i < navigableMapArray.length; ++i) {
            navigableMapArray[i] = isolinesArray[i].polylines();
        }
        return navigableMapArray;
    }

    public static List<NavigableMap<Double, Shape>> toList(Isolines[] isolinesArray) {
        return Arrays.asList(Isolines.toArray(isolinesArray));
    }

    public static List<NavigableMap<Double, Shape>> toList(Future<Isolines[]> future) {
        return new Result(future);
    }

    private static final class Process
    extends TiledProcess<Isolines[]> {
        private final double[][] levels;
        private final MathTransform gridToCRS;

        Process(RenderedImage renderedImage, double[][] dArray, MathTransform mathTransform) {
            super(renderedImage, 1, 1, Isolines.iterators());
            this.levels = dArray;
            this.gridToCRS = mathTransform;
        }

        @Override
        protected TiledProcess.Task createSubTask() {
            return new Tile();
        }

        private final class Tile
        extends TiledProcess.Task {
            private Isolines[] isolines;

            Tile() {
                super(Process.this);
            }

            @Override
            protected void execute() throws TransformException {
                this.isolines = Isolines.generate(this.iterator, Process.this.levels, Process.this.gridToCRS);
            }

            @Override
            protected void merge(TiledProcess.Task task) throws TransformException {
                for (int i = 0; i < this.isolines.length; ++i) {
                    Isolines isolines = this.isolines[i];
                    Isolines isolines2 = ((Tile)task).isolines[i];
                    for (int j = 0; j < isolines.levels.length; ++j) {
                        isolines.levels[j].merge(isolines2.levels[j]);
                    }
                }
            }

            protected Isolines[] result() throws TransformException {
                return Isolines.flush(this.isolines);
            }
        }
    }

    private static final class Result
    extends AbstractList<NavigableMap<Double, Shape>> {
        private Future<Isolines[]> task;
        private NavigableMap<Double, Shape>[] isolines;

        Result(Future<Isolines[]> future) {
            this.task = future;
        }

        private NavigableMap<Double, Shape>[] isolines() {
            if (this.isolines == null) {
                if (this.task == null) {
                    throw new CompletionException(Errors.format((short)191), null);
                }
                try {
                    this.isolines = Isolines.toArray(this.task.get());
                    this.task = null;
                }
                catch (InterruptedException interruptedException) {
                    throw new CompletionException(Errors.format((short)192), interruptedException);
                }
                catch (ExecutionException executionException) {
                    this.task = null;
                    throw new CompletionException(Errors.format((short)191), executionException.getCause());
                }
            }
            return this.isolines;
        }

        @Override
        public int size() {
            return this.isolines().length;
        }

        @Override
        public NavigableMap<Double, Shape> get(int n) {
            return this.isolines()[n];
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.isolines().clone();
        }
    }
}

