/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.io.Serializable;
import org.apache.sis.internal.feature.jts.PackedCoordinateSequence;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Coordinates;

final class PackedCoordinateSequenceFactory
implements CoordinateSequenceFactory,
Serializable {
    private static final long serialVersionUID = 8160800176640629524L;
    protected final boolean doublePrecision;

    PackedCoordinateSequenceFactory(boolean bl) {
        this.doublePrecision = bl;
    }

    public CoordinateSequence create(Coordinate[] coordinateArray) {
        int n = 3;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        if (coordinateArray != null) {
            n3 = coordinateArray.length;
            for (Coordinate coordinate : coordinateArray) {
                int n4 = Coordinates.measures((Coordinate)coordinate);
                n = Math.min(n, Coordinates.dimension((Coordinate)coordinate) - n4);
                if (!(bl | n4 < n2)) continue;
                n2 = n4;
                bl = false;
            }
        }
        PackedCoordinateSequence packedCoordinateSequence = this.create(n3, n += n2, n2);
        if (n3 != 0) {
            packedCoordinateSequence.setCoordinates(coordinateArray);
        }
        return packedCoordinateSequence;
    }

    public CoordinateSequence create(CoordinateSequence coordinateSequence) {
        int n;
        int n2;
        int n3;
        if (coordinateSequence instanceof PackedCoordinateSequence) {
            return coordinateSequence.copy();
        }
        if (coordinateSequence != null) {
            n3 = coordinateSequence.getDimension();
            n2 = coordinateSequence.getMeasures();
            n = coordinateSequence.size();
        } else {
            n3 = 3;
            n2 = 0;
            n = 0;
        }
        PackedCoordinateSequence packedCoordinateSequence = this.create(n, n3, n2);
        if (n != 0) {
            packedCoordinateSequence.setCoordinates(coordinateSequence);
        }
        return packedCoordinateSequence;
    }

    public CoordinateSequence create(int n, int n2) {
        return this.create(n, n2, 0);
    }

    public PackedCoordinateSequence create(int n, int n2, int n3) {
        if (this.doublePrecision) {
            return new PackedCoordinateSequence.Double(n, n2, n3);
        }
        return new PackedCoordinateSequence.Float(n, n2, n3);
    }
}

