/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.internal.coverage.j2d.DeferredProperty;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.resources.Errors;

public abstract class BatchComputedImage
extends ComputedImage {
    private final Map<String, Object> properties;
    private Rasters prefetched;

    protected BatchComputedImage(SampleModel sampleModel, Map<String, Object> map, RenderedImage ... renderedImageArray) {
        super(sampleModel, renderedImageArray);
        this.properties = map != null ? JDK9.copyOf(map) : Collections.emptyMap();
    }

    @Override
    public Object getProperty(String string) {
        Object object = this.properties.getOrDefault(string, Image.UndefinedProperty);
        if (object instanceof DeferredProperty) {
            object = ((DeferredProperty)object).compute(this);
        }
        return object;
    }

    @Override
    public String[] getPropertyNames() {
        int n = this.properties.size();
        return n == 0 ? null : this.properties.keySet().toArray(new String[n]);
    }

    protected abstract Raster[] computeTiles(Rectangle var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Raster computeTile(int n, int n2, WritableRaster writableRaster) throws Exception {
        Raster[] rasterArray = this;
        synchronized (this) {
            Rasters rasters = this.prefetched;
            while (rasters != null) {
                int n3 = n - rasters.x;
                int n4 = n2 - rasters.y;
                if ((n3 | n4) >= 0 && n3 < rasters.width && n4 < rasters.height) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return rasters.tiles[n3 + n4 * rasters.width];
                }
                rasters = rasters.next;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            rasterArray = this.computeTiles(new Rectangle(n, n2, 1, 1));
            if (rasterArray.length == 1) {
                return rasterArray[0];
            }
            throw new ImagingOpException(Errors.format((short)119));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Disposable prefetch(Rectangle rectangle) {
        Raster[] rasterArray;
        try {
            rasterArray = this.computeTiles(rectangle);
        }
        catch (Exception exception) {
            throw (ImagingOpException)new ImagingOpException(null).initCause(exception);
        }
        Rasters rasters = new Rasters(rectangle, rasterArray);
        BatchComputedImage batchComputedImage = this;
        synchronized (batchComputedImage) {
            rasters.next = this.prefetched;
            this.prefetched = rasters;
        }
        return rasters;
    }

    private synchronized void remove(Rasters rasters) {
        Rasters rasters2 = null;
        Rasters rasters3 = this.prefetched;
        while (rasters3 != rasters) {
            if (rasters3 == null) {
                return;
            }
            rasters2 = rasters3;
            rasters3 = rasters3.next;
        }
        rasters3 = rasters3.next;
        if (rasters2 != null) {
            rasters2.next = rasters3;
        } else {
            this.prefetched = rasters3;
        }
    }

    private final class Rasters
    implements Disposable {
        final int x;
        final int y;
        final int width;
        final int height;
        final Raster[] tiles;
        Rasters next;

        Rasters(Rectangle rectangle, Raster[] rasterArray) {
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = rectangle.width;
            this.height = rectangle.height;
            this.tiles = rasterArray;
        }

        @Override
        public void dispose() {
            BatchComputedImage.this.remove(this);
        }
    }
}

