/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.MultiValuedAssociation;
import org.apache.sis.feature.SingletonAssociation;
import org.apache.sis.feature.Validator;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.util.GenericName;

public abstract class AbstractAssociation
extends Field<AbstractFeature>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5992169056331267867L;
    final DefaultAssociationRole role;

    protected AbstractAssociation(DefaultAssociationRole defaultAssociationRole) {
        this.role = defaultAssociationRole;
    }

    public static AbstractAssociation create(DefaultAssociationRole defaultAssociationRole) {
        ArgumentChecks.ensureNonNull("role", defaultAssociationRole);
        return AbstractAssociation.isSingleton(defaultAssociationRole.getMaximumOccurs()) ? new SingletonAssociation(defaultAssociationRole) : new MultiValuedAssociation(defaultAssociationRole);
    }

    static AbstractAssociation create(DefaultAssociationRole defaultAssociationRole, Object object) {
        ArgumentChecks.ensureNonNull("role", defaultAssociationRole);
        return AbstractAssociation.isSingleton(defaultAssociationRole.getMaximumOccurs()) ? new SingletonAssociation(defaultAssociationRole, (AbstractFeature)object) : new MultiValuedAssociation(defaultAssociationRole, object);
    }

    @Override
    public GenericName getName() {
        return this.role.getName();
    }

    public DefaultAssociationRole getRole() {
        return this.role;
    }

    @Override
    public abstract AbstractFeature getValue() throws IllegalStateException;

    @Override
    public Collection<AbstractFeature> getValues() {
        return super.getValues();
    }

    @Override
    public abstract void setValue(AbstractFeature var1) throws IllegalArgumentException;

    @Override
    public void setValues(Collection<? extends AbstractFeature> collection) throws IllegalArgumentException {
        super.setValues(collection);
    }

    final void ensureValid(DefaultFeatureType defaultFeatureType, DefaultFeatureType defaultFeatureType2) {
        if (defaultFeatureType != defaultFeatureType2 && !DefaultFeatureType.maybeAssignableFrom(defaultFeatureType, defaultFeatureType2)) {
            throw new IllegalArgumentException(Resources.format((short)26, this.getName(), defaultFeatureType.getName(), defaultFeatureType2.getName()));
        }
    }

    public DataQuality quality() {
        Validator validator = new Validator(null);
        validator.validate(this.role, this.getValues());
        return validator.quality;
    }

    public String toString() {
        final String string = DefaultAssociationRole.getTitleProperty(this.role);
        final Iterator<AbstractFeature> iterator = this.getValues().iterator();
        return FieldType.toString(AbstractAssociation.isDeprecated(this.role), "FeatureAssociation", this.role.getName(), DefaultAssociationRole.getValueTypeName(this.role), new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Object next() {
                return ((AbstractFeature)iterator.next()).getPropertyValue(string);
            }
        }).toString();
    }

    public AbstractAssociation clone() throws CloneNotSupportedException {
        return (AbstractAssociation)super.clone();
    }
}

